/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateShareRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateShareRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(CreateShareRequest.getter(CreateShareRequest::resourceArn)).setter(CreateShareRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> PRINCIPAL_SUBSCRIBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalSubscriber").getter(CreateShareRequest.getter(CreateShareRequest::principalSubscriber)).setter(CreateShareRequest.setter(Builder::principalSubscriber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalSubscriber").build()}).build();
    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareName").getter(CreateShareRequest.getter(CreateShareRequest::shareName)).setter(CreateShareRequest.setter(Builder::shareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, PRINCIPAL_SUBSCRIBER_FIELD, SHARE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateShareRequest.memberNameToFieldInitializer();
    private final String resourceArn;
    private final String principalSubscriber;
    private final String shareName;

    private CreateShareRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.principalSubscriber = builder.principalSubscriber;
        this.shareName = builder.shareName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String principalSubscriber() {
        return this.principalSubscriber;
    }

    public final String shareName() {
        return this.shareName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalSubscriber());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateShareRequest)) {
            return false;
        }
        CreateShareRequest other = (CreateShareRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.principalSubscriber(), other.principalSubscriber()) && Objects.equals(this.shareName(), other.shareName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateShareRequest").add("ResourceArn", (Object)this.resourceArn()).add("PrincipalSubscriber", (Object)this.principalSubscriber()).add("ShareName", (Object)this.shareName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "principalSubscriber": {
                return Optional.ofNullable(clazz.cast(this.principalSubscriber()));
            }
            case "shareName": {
                return Optional.ofNullable(clazz.cast(this.shareName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("principalSubscriber", PRINCIPAL_SUBSCRIBER_FIELD);
        map.put("shareName", SHARE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateShareRequest, T> g) {
        return obj -> g.apply((CreateShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String principalSubscriber;
        private String shareName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateShareRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.principalSubscriber(model.principalSubscriber);
            this.shareName(model.shareName);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPrincipalSubscriber() {
            return this.principalSubscriber;
        }

        public final void setPrincipalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
        }

        @Override
        public final Builder principalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
            return this;
        }

        public final String getShareName() {
            return this.shareName;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        @Override
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateShareRequest build() {
            return new CreateShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateShareRequest> {
        public Builder resourceArn(String var1);

        public Builder principalSubscriber(String var1);

        public Builder shareName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

