/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowVersionResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, CreateWorkflowVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateWorkflowVersionResponse.getter(CreateWorkflowVersionResponse::arn)).setter(CreateWorkflowVersionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(CreateWorkflowVersionResponse.getter(CreateWorkflowVersionResponse::workflowId)).setter(CreateWorkflowVersionResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(CreateWorkflowVersionResponse.getter(CreateWorkflowVersionResponse::versionName)).setter(CreateWorkflowVersionResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateWorkflowVersionResponse.getter(CreateWorkflowVersionResponse::statusAsString)).setter(CreateWorkflowVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorkflowVersionResponse.getter(CreateWorkflowVersionResponse::tags)).setter(CreateWorkflowVersionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uuid").getter(CreateWorkflowVersionResponse.getter(CreateWorkflowVersionResponse::uuid)).setter(CreateWorkflowVersionResponse.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WORKFLOW_ID_FIELD, VERSION_NAME_FIELD, STATUS_FIELD, TAGS_FIELD, UUID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowVersionResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String workflowId;
    private final String versionName;
    private final String status;
    private final Map<String, String> tags;
    private final String uuid;

    private CreateWorkflowVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.workflowId = builder.workflowId;
        this.versionName = builder.versionName;
        this.status = builder.status;
        this.tags = builder.tags;
        this.uuid = builder.uuid;
    }

    public final String arn() {
        return this.arn;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String uuid() {
        return this.uuid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowVersionResponse)) {
            return false;
        }
        CreateWorkflowVersionResponse other = (CreateWorkflowVersionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.uuid(), other.uuid());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowVersionResponse").add("Arn", (Object)this.arn()).add("WorkflowId", (Object)this.workflowId()).add("VersionName", (Object)this.versionName()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Uuid", (Object)this.uuid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "uuid": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("uuid", UUID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowVersionResponse, T> g) {
        return obj -> g.apply((CreateWorkflowVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String workflowId;
        private String versionName;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String uuid;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowVersionResponse model) {
            super(model);
            this.arn(model.arn);
            this.workflowId(model.workflowId);
            this.versionName(model.versionName);
            this.status(model.status);
            this.tags(model.tags);
            this.uuid(model.uuid);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        @Override
        public CreateWorkflowVersionResponse build() {
            return new CreateWorkflowVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowVersionResponse> {
        public Builder arn(String var1);

        public Builder workflowId(String var1);

        public Builder versionName(String var1);

        public Builder status(String var1);

        public Builder status(WorkflowStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder uuid(String var1);
    }
}

