/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.Accelerators;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.StorageType;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowEngine;
import software.amazon.awssdk.services.omics.model.WorkflowParameter;
import software.amazon.awssdk.services.omics.model.WorkflowParameterTemplateCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowVersionRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateWorkflowVersionRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::workflowId)).setter(CreateWorkflowVersionRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowId").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::versionName)).setter(CreateWorkflowVersionRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<SdkBytes> DEFINITION_ZIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("definitionZip").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::definitionZip)).setter(CreateWorkflowVersionRequest.setter(Builder::definitionZip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionZip").build()}).build();
    private static final SdkField<String> DEFINITION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definitionUri").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::definitionUri)).setter(CreateWorkflowVersionRequest.setter(Builder::definitionUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionUri").build()}).build();
    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accelerators").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::acceleratorsAsString)).setter(CreateWorkflowVersionRequest.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::description)).setter(CreateWorkflowVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::engineAsString)).setter(CreateWorkflowVersionRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> MAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("main").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::main)).setter(CreateWorkflowVersionRequest.setter(Builder::main)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()}).build();
    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameterTemplate").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::parameterTemplate)).setter(CreateWorkflowVersionRequest.setter(Builder::parameterTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::requestId)).setter(CreateWorkflowVersionRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::storageTypeAsString)).setter(CreateWorkflowVersionRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::storageCapacity)).setter(CreateWorkflowVersionRequest.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::tags)).setter(CreateWorkflowVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_BUCKET_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowBucketOwnerId").getter(CreateWorkflowVersionRequest.getter(CreateWorkflowVersionRequest::workflowBucketOwnerId)).setter(CreateWorkflowVersionRequest.setter(Builder::workflowBucketOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBucketOwnerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, VERSION_NAME_FIELD, DEFINITION_ZIP_FIELD, DEFINITION_URI_FIELD, ACCELERATORS_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, MAIN_FIELD, PARAMETER_TEMPLATE_FIELD, REQUEST_ID_FIELD, STORAGE_TYPE_FIELD, STORAGE_CAPACITY_FIELD, TAGS_FIELD, WORKFLOW_BUCKET_OWNER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowVersionRequest.memberNameToFieldInitializer();
    private final String workflowId;
    private final String versionName;
    private final SdkBytes definitionZip;
    private final String definitionUri;
    private final String accelerators;
    private final String description;
    private final String engine;
    private final String main;
    private final Map<String, WorkflowParameter> parameterTemplate;
    private final String requestIdValue;
    private final String storageType;
    private final Integer storageCapacity;
    private final Map<String, String> tags;
    private final String workflowBucketOwnerId;

    private CreateWorkflowVersionRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.versionName = builder.versionName;
        this.definitionZip = builder.definitionZip;
        this.definitionUri = builder.definitionUri;
        this.accelerators = builder.accelerators;
        this.description = builder.description;
        this.engine = builder.engine;
        this.main = builder.main;
        this.parameterTemplate = builder.parameterTemplate;
        this.requestIdValue = builder.requestIdValue;
        this.storageType = builder.storageType;
        this.storageCapacity = builder.storageCapacity;
        this.tags = builder.tags;
        this.workflowBucketOwnerId = builder.workflowBucketOwnerId;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final SdkBytes definitionZip() {
        return this.definitionZip;
    }

    public final String definitionUri() {
        return this.definitionUri;
    }

    public final Accelerators accelerators() {
        return Accelerators.fromValue(this.accelerators);
    }

    public final String acceleratorsAsString() {
        return this.accelerators;
    }

    public final String description() {
        return this.description;
    }

    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final String main() {
        return this.main;
    }

    public final boolean hasParameterTemplate() {
        return this.parameterTemplate != null && !(this.parameterTemplate instanceof SdkAutoConstructMap);
    }

    public final Map<String, WorkflowParameter> parameterTemplate() {
        return this.parameterTemplate;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workflowBucketOwnerId() {
        return this.workflowBucketOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionZip());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.main());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterTemplate() ? this.parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowBucketOwnerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowVersionRequest)) {
            return false;
        }
        CreateWorkflowVersionRequest other = (CreateWorkflowVersionRequest)((Object)obj);
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.definitionZip(), other.definitionZip()) && Objects.equals(this.definitionUri(), other.definitionUri()) && Objects.equals(this.acceleratorsAsString(), other.acceleratorsAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.main(), other.main()) && this.hasParameterTemplate() == other.hasParameterTemplate() && Objects.equals(this.parameterTemplate(), other.parameterTemplate()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workflowBucketOwnerId(), other.workflowBucketOwnerId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowVersionRequest").add("WorkflowId", (Object)this.workflowId()).add("VersionName", (Object)this.versionName()).add("DefinitionZip", (Object)this.definitionZip()).add("DefinitionUri", (Object)this.definitionUri()).add("Accelerators", (Object)this.acceleratorsAsString()).add("Description", (Object)this.description()).add("Engine", (Object)this.engineAsString()).add("Main", (Object)this.main()).add("ParameterTemplate", this.hasParameterTemplate() ? this.parameterTemplate() : null).add("RequestId", (Object)this.requestId()).add("StorageType", (Object)this.storageTypeAsString()).add("StorageCapacity", (Object)this.storageCapacity()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkflowBucketOwnerId", (Object)this.workflowBucketOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "definitionZip": {
                return Optional.ofNullable(clazz.cast(this.definitionZip()));
            }
            case "definitionUri": {
                return Optional.ofNullable(clazz.cast(this.definitionUri()));
            }
            case "accelerators": {
                return Optional.ofNullable(clazz.cast(this.acceleratorsAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "main": {
                return Optional.ofNullable(clazz.cast(this.main()));
            }
            case "parameterTemplate": {
                return Optional.ofNullable(clazz.cast(this.parameterTemplate()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workflowBucketOwnerId": {
                return Optional.ofNullable(clazz.cast(this.workflowBucketOwnerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("definitionZip", DEFINITION_ZIP_FIELD);
        map.put("definitionUri", DEFINITION_URI_FIELD);
        map.put("accelerators", ACCELERATORS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engine", ENGINE_FIELD);
        map.put("main", MAIN_FIELD);
        map.put("parameterTemplate", PARAMETER_TEMPLATE_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workflowBucketOwnerId", WORKFLOW_BUCKET_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowVersionRequest, T> g) {
        return obj -> g.apply((CreateWorkflowVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String workflowId;
        private String versionName;
        private SdkBytes definitionZip;
        private String definitionUri;
        private String accelerators;
        private String description;
        private String engine;
        private String main;
        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();
        private String requestIdValue;
        private String storageType;
        private Integer storageCapacity;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workflowBucketOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowVersionRequest model) {
            super(model);
            this.workflowId(model.workflowId);
            this.versionName(model.versionName);
            this.definitionZip(model.definitionZip);
            this.definitionUri(model.definitionUri);
            this.accelerators(model.accelerators);
            this.description(model.description);
            this.engine(model.engine);
            this.main(model.main);
            this.parameterTemplate(model.parameterTemplate);
            this.requestId(model.requestIdValue);
            this.storageType(model.storageType);
            this.storageCapacity(model.storageCapacity);
            this.tags(model.tags);
            this.workflowBucketOwnerId(model.workflowBucketOwnerId);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final ByteBuffer getDefinitionZip() {
            return this.definitionZip == null ? null : this.definitionZip.asByteBuffer();
        }

        public final void setDefinitionZip(ByteBuffer definitionZip) {
            this.definitionZip(definitionZip == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)definitionZip));
        }

        @Override
        public final Builder definitionZip(SdkBytes definitionZip) {
            this.definitionZip = definitionZip;
            return this;
        }

        public final String getDefinitionUri() {
            return this.definitionUri;
        }

        public final void setDefinitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
        }

        @Override
        public final Builder definitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        public final String getAccelerators() {
            return this.accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getMain() {
            return this.main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkflowBucketOwnerId() {
            return this.workflowBucketOwnerId;
        }

        public final void setWorkflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
        }

        @Override
        public final Builder workflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowVersionRequest build() {
            return new CreateWorkflowVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowVersionRequest> {
        public Builder workflowId(String var1);

        public Builder versionName(String var1);

        public Builder definitionZip(SdkBytes var1);

        public Builder definitionUri(String var1);

        public Builder accelerators(String var1);

        public Builder accelerators(Accelerators var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder engine(WorkflowEngine var1);

        public Builder main(String var1);

        public Builder parameterTemplate(Map<String, WorkflowParameter> var1);

        public Builder requestId(String var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder storageCapacity(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder workflowBucketOwnerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

