/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.StoreType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutS3AccessPolicyResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, PutS3AccessPolicyResponse> {
    private static final SdkField<String> S3_ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3AccessPointArn").getter(PutS3AccessPolicyResponse.getter(PutS3AccessPolicyResponse::s3AccessPointArn)).setter(PutS3AccessPolicyResponse.setter(Builder::s3AccessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessPointArn").build()}).build();
    private static final SdkField<String> STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeId").getter(PutS3AccessPolicyResponse.getter(PutS3AccessPolicyResponse::storeId)).setter(PutS3AccessPolicyResponse.setter(Builder::storeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()}).build();
    private static final SdkField<String> STORE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeType").getter(PutS3AccessPolicyResponse.getter(PutS3AccessPolicyResponse::storeTypeAsString)).setter(PutS3AccessPolicyResponse.setter(Builder::storeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACCESS_POINT_ARN_FIELD, STORE_ID_FIELD, STORE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutS3AccessPolicyResponse.memberNameToFieldInitializer();
    private final String s3AccessPointArn;
    private final String storeId;
    private final String storeType;

    private PutS3AccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.s3AccessPointArn = builder.s3AccessPointArn;
        this.storeId = builder.storeId;
        this.storeType = builder.storeType;
    }

    public final String s3AccessPointArn() {
        return this.s3AccessPointArn;
    }

    public final String storeId() {
        return this.storeId;
    }

    public final StoreType storeType() {
        return StoreType.fromValue(this.storeType);
    }

    public final String storeTypeAsString() {
        return this.storeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutS3AccessPolicyResponse)) {
            return false;
        }
        PutS3AccessPolicyResponse other = (PutS3AccessPolicyResponse)((Object)obj);
        return Objects.equals(this.s3AccessPointArn(), other.s3AccessPointArn()) && Objects.equals(this.storeId(), other.storeId()) && Objects.equals(this.storeTypeAsString(), other.storeTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutS3AccessPolicyResponse").add("S3AccessPointArn", (Object)this.s3AccessPointArn()).add("StoreId", (Object)this.storeId()).add("StoreType", (Object)this.storeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.s3AccessPointArn()));
            }
            case "storeId": {
                return Optional.ofNullable(clazz.cast(this.storeId()));
            }
            case "storeType": {
                return Optional.ofNullable(clazz.cast(this.storeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("s3AccessPointArn", S3_ACCESS_POINT_ARN_FIELD);
        map.put("storeId", STORE_ID_FIELD);
        map.put("storeType", STORE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutS3AccessPolicyResponse, T> g) {
        return obj -> g.apply((PutS3AccessPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String s3AccessPointArn;
        private String storeId;
        private String storeType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutS3AccessPolicyResponse model) {
            super(model);
            this.s3AccessPointArn(model.s3AccessPointArn);
            this.storeId(model.storeId);
            this.storeType(model.storeType);
        }

        public final String getS3AccessPointArn() {
            return this.s3AccessPointArn;
        }

        public final void setS3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
        }

        @Override
        public final Builder s3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
            return this;
        }

        public final String getStoreId() {
            return this.storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final String getStoreType() {
            return this.storeType;
        }

        public final void setStoreType(String storeType) {
            this.storeType = storeType;
        }

        @Override
        public final Builder storeType(String storeType) {
            this.storeType = storeType;
            return this;
        }

        @Override
        public final Builder storeType(StoreType storeType) {
            this.storeType(storeType == null ? null : storeType.toString());
            return this;
        }

        @Override
        public PutS3AccessPolicyResponse build() {
            return new PutS3AccessPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutS3AccessPolicyResponse> {
        public Builder s3AccessPointArn(String var1);

        public Builder storeId(String var1);

        public Builder storeType(String var1);

        public Builder storeType(StoreType var1);
    }
}

