/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.VersionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAnnotationStoreVersionsRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, DeleteAnnotationStoreVersionsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeleteAnnotationStoreVersionsRequest.getter(DeleteAnnotationStoreVersionsRequest::name)).setter(DeleteAnnotationStoreVersionsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("versions").getter(DeleteAnnotationStoreVersionsRequest.getter(DeleteAnnotationStoreVersionsRequest::versions)).setter(DeleteAnnotationStoreVersionsRequest.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("force").getter(DeleteAnnotationStoreVersionsRequest.getter(DeleteAnnotationStoreVersionsRequest::force)).setter(DeleteAnnotationStoreVersionsRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSIONS_FIELD, FORCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAnnotationStoreVersionsRequest.memberNameToFieldInitializer();
    private final String name;
    private final List<String> versions;
    private final Boolean force;

    private DeleteAnnotationStoreVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versions = builder.versions;
        this.force = builder.force;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public final List<String> versions() {
        return this.versions;
    }

    public final Boolean force() {
        return this.force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersions() ? this.versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnnotationStoreVersionsRequest)) {
            return false;
        }
        DeleteAnnotationStoreVersionsRequest other = (DeleteAnnotationStoreVersionsRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasVersions() == other.hasVersions() && Objects.equals(this.versions(), other.versions()) && Objects.equals(this.force(), other.force());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAnnotationStoreVersionsRequest").add("Name", (Object)this.name()).add("Versions", this.hasVersions() ? this.versions() : null).add("Force", (Object)this.force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("versions", VERSIONS_FIELD);
        map.put("force", FORCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnnotationStoreVersionsRequest, T> g) {
        return obj -> g.apply((DeleteAnnotationStoreVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnnotationStoreVersionsRequest model) {
            super(model);
            this.name(model.name);
            this.versions(model.versions);
            this.force(model.force);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getVersions() {
            if (this.versions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.versions;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionListCopier.copy(versions);
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final Boolean getForce() {
            return this.force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAnnotationStoreVersionsRequest build() {
            return new DeleteAnnotationStoreVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAnnotationStoreVersionsRequest> {
        public Builder name(String var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder force(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

