/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetUploadPartListCopier;
import software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReadSetUploadPartsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListReadSetUploadPartsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReadSetUploadPartsResponse.getter(ListReadSetUploadPartsResponse::nextToken)).setter(ListReadSetUploadPartsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ReadSetUploadPartListItem>> PARTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parts").getter(ListReadSetUploadPartsResponse.getter(ListReadSetUploadPartsResponse::parts)).setter(ListReadSetUploadPartsResponse.setter(Builder::parts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReadSetUploadPartListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PARTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReadSetUploadPartsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ReadSetUploadPartListItem> parts;

    private ListReadSetUploadPartsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.parts = builder.parts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasParts() {
        return this.parts != null && !(this.parts instanceof SdkAutoConstructList);
    }

    public final List<ReadSetUploadPartListItem> parts() {
        return this.parts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParts() ? this.parts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetUploadPartsResponse)) {
            return false;
        }
        ListReadSetUploadPartsResponse other = (ListReadSetUploadPartsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasParts() == other.hasParts() && Objects.equals(this.parts(), other.parts());
    }

    public final String toString() {
        return ToString.builder((String)"ListReadSetUploadPartsResponse").add("NextToken", (Object)this.nextToken()).add("Parts", this.hasParts() ? this.parts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "parts": {
                return Optional.ofNullable(clazz.cast(this.parts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("parts", PARTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetUploadPartsResponse, T> g) {
        return obj -> g.apply((ListReadSetUploadPartsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReadSetUploadPartListItem> parts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetUploadPartsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.parts(model.parts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReadSetUploadPartListItem.Builder> getParts() {
            List<ReadSetUploadPartListItem.Builder> result = ReadSetUploadPartListCopier.copyToBuilder(this.parts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParts(Collection<ReadSetUploadPartListItem.BuilderImpl> parts) {
            this.parts = ReadSetUploadPartListCopier.copyFromBuilder(parts);
        }

        @Override
        public final Builder parts(Collection<ReadSetUploadPartListItem> parts) {
            this.parts = ReadSetUploadPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(ReadSetUploadPartListItem ... parts) {
            this.parts(Arrays.asList(parts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Consumer<ReadSetUploadPartListItem.Builder> ... parts) {
            this.parts(Stream.of(parts).map(c -> (ReadSetUploadPartListItem)((ReadSetUploadPartListItem.Builder)ReadSetUploadPartListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetUploadPartsResponse build() {
            return new ListReadSetUploadPartsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReadSetUploadPartsResponse> {
        public Builder nextToken(String var1);

        public Builder parts(Collection<ReadSetUploadPartListItem> var1);

        public Builder parts(ReadSetUploadPartListItem ... var1);

        public Builder parts(Consumer<ReadSetUploadPartListItem.Builder> ... var1);
    }
}

