/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListSharesRequest;
import software.amazon.awssdk.services.omics.model.ListSharesResponse;
import software.amazon.awssdk.services.omics.model.ShareDetails;

public class ListSharesIterable
implements SdkIterable<ListSharesResponse> {
    private final OmicsClient client;
    private final ListSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSharesIterable(OmicsClient client, ListSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSharesResponseFetcher();
    }

    public Iterator<ListSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ShareDetails> shares() {
        Function<ListSharesResponse, Iterator> getIterator = response -> {
            if (response != null && response.shares() != null) {
                return response.shares().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSharesResponseFetcher
    implements SyncPageFetcher<ListSharesResponse> {
        private ListSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSharesResponse nextPage(ListSharesResponse previousPage) {
            if (previousPage == null) {
                return ListSharesIterable.this.client.listShares(ListSharesIterable.this.firstRequest);
            }
            return ListSharesIterable.this.client.listShares((ListSharesRequest)((Object)ListSharesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

