/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ReadSetPartSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadSetUploadPartListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadSetUploadPartListItem> {
    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("partNumber").getter(ReadSetUploadPartListItem.getter(ReadSetUploadPartListItem::partNumber)).setter(ReadSetUploadPartListItem.setter(Builder::partNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partNumber").build()}).build();
    private static final SdkField<Long> PART_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("partSize").getter(ReadSetUploadPartListItem.getter(ReadSetUploadPartListItem::partSize)).setter(ReadSetUploadPartListItem.setter(Builder::partSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSize").build()}).build();
    private static final SdkField<String> PART_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partSource").getter(ReadSetUploadPartListItem.getter(ReadSetUploadPartListItem::partSourceAsString)).setter(ReadSetUploadPartListItem.setter(Builder::partSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSource").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checksum").getter(ReadSetUploadPartListItem.getter(ReadSetUploadPartListItem::checksum)).setter(ReadSetUploadPartListItem.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ReadSetUploadPartListItem.getter(ReadSetUploadPartListItem::creationTime)).setter(ReadSetUploadPartListItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(ReadSetUploadPartListItem.getter(ReadSetUploadPartListItem::lastUpdatedTime)).setter(ReadSetUploadPartListItem.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PART_NUMBER_FIELD, PART_SIZE_FIELD, PART_SOURCE_FIELD, CHECKSUM_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReadSetUploadPartListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer partNumber;
    private final Long partSize;
    private final String partSource;
    private final String checksum;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;

    private ReadSetUploadPartListItem(BuilderImpl builder) {
        this.partNumber = builder.partNumber;
        this.partSize = builder.partSize;
        this.partSource = builder.partSource;
        this.checksum = builder.checksum;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final Integer partNumber() {
        return this.partNumber;
    }

    public final Long partSize() {
        return this.partSize;
    }

    public final ReadSetPartSource partSource() {
        return ReadSetPartSource.fromValue(this.partSource);
    }

    public final String partSourceAsString() {
        return this.partSource;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadSetUploadPartListItem)) {
            return false;
        }
        ReadSetUploadPartListItem other = (ReadSetUploadPartListItem)obj;
        return Objects.equals(this.partNumber(), other.partNumber()) && Objects.equals(this.partSize(), other.partSize()) && Objects.equals(this.partSourceAsString(), other.partSourceAsString()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ReadSetUploadPartListItem").add("PartNumber", (Object)this.partNumber()).add("PartSize", (Object)this.partSize()).add("PartSource", (Object)this.partSourceAsString()).add("Checksum", (Object)this.checksum()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "partNumber": {
                return Optional.ofNullable(clazz.cast(this.partNumber()));
            }
            case "partSize": {
                return Optional.ofNullable(clazz.cast(this.partSize()));
            }
            case "partSource": {
                return Optional.ofNullable(clazz.cast(this.partSourceAsString()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("partNumber", PART_NUMBER_FIELD);
        map.put("partSize", PART_SIZE_FIELD);
        map.put("partSource", PART_SOURCE_FIELD);
        map.put("checksum", CHECKSUM_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadSetUploadPartListItem, T> g) {
        return obj -> g.apply((ReadSetUploadPartListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer partNumber;
        private Long partSize;
        private String partSource;
        private String checksum;
        private Instant creationTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadSetUploadPartListItem model) {
            this.partNumber(model.partNumber);
            this.partSize(model.partSize);
            this.partSource(model.partSource);
            this.checksum(model.checksum);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final Long getPartSize() {
            return this.partSize;
        }

        public final void setPartSize(Long partSize) {
            this.partSize = partSize;
        }

        @Override
        public final Builder partSize(Long partSize) {
            this.partSize = partSize;
            return this;
        }

        public final String getPartSource() {
            return this.partSource;
        }

        public final void setPartSource(String partSource) {
            this.partSource = partSource;
        }

        @Override
        public final Builder partSource(String partSource) {
            this.partSource = partSource;
            return this;
        }

        @Override
        public final Builder partSource(ReadSetPartSource partSource) {
            this.partSource(partSource == null ? null : partSource.toString());
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public ReadSetUploadPartListItem build() {
            return new ReadSetUploadPartListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadSetUploadPartListItem> {
        public Builder partNumber(Integer var1);

        public Builder partSize(Long var1);

        public Builder partSource(String var1);

        public Builder partSource(ReadSetPartSource var1);

        public Builder checksum(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

