/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.SequenceStoreDetail;
import software.amazon.awssdk.services.omics.model.SequenceStoreDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSequenceStoresResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListSequenceStoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSequenceStoresResponse.getter(ListSequenceStoresResponse::nextToken)).setter(ListSequenceStoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SequenceStoreDetail>> SEQUENCE_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sequenceStores").getter(ListSequenceStoresResponse.getter(ListSequenceStoresResponse::sequenceStores)).setter(ListSequenceStoresResponse.setter(Builder::sequenceStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SequenceStoreDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SEQUENCE_STORES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("sequenceStores", SEQUENCE_STORES_FIELD);
        }
    });
    private final String nextToken;
    private final List<SequenceStoreDetail> sequenceStores;

    private ListSequenceStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sequenceStores = builder.sequenceStores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSequenceStores() {
        return this.sequenceStores != null && !(this.sequenceStores instanceof SdkAutoConstructList);
    }

    public final List<SequenceStoreDetail> sequenceStores() {
        return this.sequenceStores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSequenceStores() ? this.sequenceStores() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSequenceStoresResponse)) {
            return false;
        }
        ListSequenceStoresResponse other = (ListSequenceStoresResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSequenceStores() == other.hasSequenceStores() && Objects.equals(this.sequenceStores(), other.sequenceStores());
    }

    public final String toString() {
        return ToString.builder((String)"ListSequenceStoresResponse").add("NextToken", (Object)this.nextToken()).add("SequenceStores", this.hasSequenceStores() ? this.sequenceStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sequenceStores": {
                return Optional.ofNullable(clazz.cast(this.sequenceStores()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSequenceStoresResponse, T> g) {
        return obj -> g.apply((ListSequenceStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SequenceStoreDetail> sequenceStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSequenceStoresResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sequenceStores(model.sequenceStores);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SequenceStoreDetail.Builder> getSequenceStores() {
            List<SequenceStoreDetail.Builder> result = SequenceStoreDetailListCopier.copyToBuilder(this.sequenceStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSequenceStores(Collection<SequenceStoreDetail.BuilderImpl> sequenceStores) {
            this.sequenceStores = SequenceStoreDetailListCopier.copyFromBuilder(sequenceStores);
        }

        @Override
        public final Builder sequenceStores(Collection<SequenceStoreDetail> sequenceStores) {
            this.sequenceStores = SequenceStoreDetailListCopier.copy(sequenceStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceStores(SequenceStoreDetail ... sequenceStores) {
            this.sequenceStores(Arrays.asList(sequenceStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceStores(Consumer<SequenceStoreDetail.Builder> ... sequenceStores) {
            this.sequenceStores(Stream.of(sequenceStores).map(c -> (SequenceStoreDetail)((SequenceStoreDetail.Builder)SequenceStoreDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSequenceStoresResponse build() {
            return new ListSequenceStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSequenceStoresResponse> {
        public Builder nextToken(String var1);

        public Builder sequenceStores(Collection<SequenceStoreDetail> var1);

        public Builder sequenceStores(SequenceStoreDetail ... var1);

        public Builder sequenceStores(Consumer<SequenceStoreDetail.Builder> ... var1);
    }
}

