/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.AnnotationType;
import software.amazon.awssdk.services.omics.model.FormatToHeaderCopier;
import software.amazon.awssdk.services.omics.model.FormatToHeaderKey;
import software.amazon.awssdk.services.omics.model.SchemaValueType;
import software.amazon.awssdk.services.omics.model.TsvVersionOptionsSchemaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TsvVersionOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TsvVersionOptions> {
    private static final SdkField<String> ANNOTATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("annotationType").getter(TsvVersionOptions.getter(TsvVersionOptions::annotationTypeAsString)).setter(TsvVersionOptions.setter(Builder::annotationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationType").build()}).build();
    private static final SdkField<Map<String, String>> FORMAT_TO_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("formatToHeader").getter(TsvVersionOptions.getter(TsvVersionOptions::formatToHeaderAsStrings)).setter(TsvVersionOptions.setter(Builder::formatToHeaderWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatToHeader").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, String>>> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schema").getter(TsvVersionOptions.getter(TsvVersionOptions::schemaAsStrings)).setter(TsvVersionOptions.setter(Builder::schemaWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_TYPE_FIELD, FORMAT_TO_HEADER_FIELD, SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("annotationType", ANNOTATION_TYPE_FIELD);
            this.put("formatToHeader", FORMAT_TO_HEADER_FIELD);
            this.put("schema", SCHEMA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String annotationType;
    private final Map<String, String> formatToHeader;
    private final List<Map<String, String>> schema;

    private TsvVersionOptions(BuilderImpl builder) {
        this.annotationType = builder.annotationType;
        this.formatToHeader = builder.formatToHeader;
        this.schema = builder.schema;
    }

    public final AnnotationType annotationType() {
        return AnnotationType.fromValue(this.annotationType);
    }

    public final String annotationTypeAsString() {
        return this.annotationType;
    }

    public final Map<FormatToHeaderKey, String> formatToHeader() {
        return FormatToHeaderCopier.copyStringToEnum(this.formatToHeader);
    }

    public final boolean hasFormatToHeader() {
        return this.formatToHeader != null && !(this.formatToHeader instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> formatToHeaderAsStrings() {
        return this.formatToHeader;
    }

    public final List<Map<String, SchemaValueType>> schema() {
        return TsvVersionOptionsSchemaListCopier.copyStringToEnum(this.schema);
    }

    public final boolean hasSchema() {
        return this.schema != null && !(this.schema instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> schemaAsStrings() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormatToHeader() ? this.formatToHeaderAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchema() ? this.schemaAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TsvVersionOptions)) {
            return false;
        }
        TsvVersionOptions other = (TsvVersionOptions)obj;
        return Objects.equals(this.annotationTypeAsString(), other.annotationTypeAsString()) && this.hasFormatToHeader() == other.hasFormatToHeader() && Objects.equals(this.formatToHeaderAsStrings(), other.formatToHeaderAsStrings()) && this.hasSchema() == other.hasSchema() && Objects.equals(this.schemaAsStrings(), other.schemaAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TsvVersionOptions").add("AnnotationType", (Object)this.annotationTypeAsString()).add("FormatToHeader", this.hasFormatToHeader() ? this.formatToHeaderAsStrings() : null).add("Schema", this.hasSchema() ? this.schemaAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "annotationType": {
                return Optional.ofNullable(clazz.cast(this.annotationTypeAsString()));
            }
            case "formatToHeader": {
                return Optional.ofNullable(clazz.cast(this.formatToHeaderAsStrings()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schemaAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TsvVersionOptions, T> g) {
        return obj -> g.apply((TsvVersionOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String annotationType;
        private Map<String, String> formatToHeader = DefaultSdkAutoConstructMap.getInstance();
        private List<Map<String, String>> schema = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TsvVersionOptions model) {
            this.annotationType(model.annotationType);
            this.formatToHeaderWithStrings(model.formatToHeader);
            this.schemaWithStrings(model.schema);
        }

        public final String getAnnotationType() {
            return this.annotationType;
        }

        public final void setAnnotationType(String annotationType) {
            this.annotationType = annotationType;
        }

        @Override
        public final Builder annotationType(String annotationType) {
            this.annotationType = annotationType;
            return this;
        }

        @Override
        public final Builder annotationType(AnnotationType annotationType) {
            this.annotationType(annotationType == null ? null : annotationType.toString());
            return this;
        }

        public final Map<String, String> getFormatToHeader() {
            if (this.formatToHeader instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.formatToHeader;
        }

        public final void setFormatToHeader(Map<String, String> formatToHeader) {
            this.formatToHeader = FormatToHeaderCopier.copy(formatToHeader);
        }

        @Override
        public final Builder formatToHeaderWithStrings(Map<String, String> formatToHeader) {
            this.formatToHeader = FormatToHeaderCopier.copy(formatToHeader);
            return this;
        }

        @Override
        public final Builder formatToHeader(Map<FormatToHeaderKey, String> formatToHeader) {
            this.formatToHeader = FormatToHeaderCopier.copyEnumToString(formatToHeader);
            return this;
        }

        public final Collection<? extends Map<String, String>> getSchema() {
            if (this.schema instanceof SdkAutoConstructList) {
                return null;
            }
            return this.schema;
        }

        public final void setSchema(Collection<? extends Map<String, String>> schema) {
            this.schema = TsvVersionOptionsSchemaListCopier.copy(schema);
        }

        @Override
        public final Builder schemaWithStrings(Collection<? extends Map<String, String>> schema) {
            this.schema = TsvVersionOptionsSchemaListCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaWithStrings(Map<String, String> ... schema) {
            this.schemaWithStrings(Arrays.asList(schema));
            return this;
        }

        public TsvVersionOptions build() {
            return new TsvVersionOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TsvVersionOptions> {
        public Builder annotationType(String var1);

        public Builder annotationType(AnnotationType var1);

        public Builder formatToHeaderWithStrings(Map<String, String> var1);

        public Builder formatToHeader(Map<FormatToHeaderKey, String> var1);

        public Builder schemaWithStrings(Collection<? extends Map<String, String>> var1);

        public Builder schemaWithStrings(Map<String, String> ... var1);
    }
}

