/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.CacheBehavior;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRunCacheRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, UpdateRunCacheRequest> {
    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheBehavior").getter(UpdateRunCacheRequest.getter(UpdateRunCacheRequest::cacheBehaviorAsString)).setter(UpdateRunCacheRequest.setter(Builder::cacheBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateRunCacheRequest.getter(UpdateRunCacheRequest::description)).setter(UpdateRunCacheRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateRunCacheRequest.getter(UpdateRunCacheRequest::id)).setter(UpdateRunCacheRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateRunCacheRequest.getter(UpdateRunCacheRequest::name)).setter(UpdateRunCacheRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_BEHAVIOR_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private final String cacheBehavior;
    private final String description;
    private final String id;
    private final String name;

    private UpdateRunCacheRequest(BuilderImpl builder) {
        super(builder);
        this.cacheBehavior = builder.cacheBehavior;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
    }

    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(this.cacheBehavior);
    }

    public final String cacheBehaviorAsString() {
        return this.cacheBehavior;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRunCacheRequest)) {
            return false;
        }
        UpdateRunCacheRequest other = (UpdateRunCacheRequest)((Object)obj);
        return Objects.equals(this.cacheBehaviorAsString(), other.cacheBehaviorAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRunCacheRequest").add("CacheBehavior", (Object)this.cacheBehaviorAsString()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRunCacheRequest, T> g) {
        return obj -> g.apply((UpdateRunCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String cacheBehavior;
        private String description;
        private String id;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRunCacheRequest model) {
            super(model);
            this.cacheBehavior(model.cacheBehavior);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
        }

        public final String getCacheBehavior() {
            return this.cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRunCacheRequest build() {
            return new UpdateRunCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRunCacheRequest> {
        public Builder cacheBehavior(String var1);

        public Builder cacheBehavior(CacheBehavior var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

