/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.CacheBehavior;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRunCacheRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateRunCacheRequest> {
    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheBehavior").getter(CreateRunCacheRequest.getter(CreateRunCacheRequest::cacheBehaviorAsString)).setter(CreateRunCacheRequest.setter(Builder::cacheBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()}).build();
    private static final SdkField<String> CACHE_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheS3Location").getter(CreateRunCacheRequest.getter(CreateRunCacheRequest::cacheS3Location)).setter(CreateRunCacheRequest.setter(Builder::cacheS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Location").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateRunCacheRequest.getter(CreateRunCacheRequest::description)).setter(CreateRunCacheRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRunCacheRequest.getter(CreateRunCacheRequest::name)).setter(CreateRunCacheRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(CreateRunCacheRequest.getter(CreateRunCacheRequest::requestId)).setter(CreateRunCacheRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRunCacheRequest.getter(CreateRunCacheRequest::tags)).setter(CreateRunCacheRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CACHE_BUCKET_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheBucketOwnerId").getter(CreateRunCacheRequest.getter(CreateRunCacheRequest::cacheBucketOwnerId)).setter(CreateRunCacheRequest.setter(Builder::cacheBucketOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBucketOwnerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_BEHAVIOR_FIELD, CACHE_S3_LOCATION_FIELD, DESCRIPTION_FIELD, NAME_FIELD, REQUEST_ID_FIELD, TAGS_FIELD, CACHE_BUCKET_OWNER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
            this.put("cacheS3Location", CACHE_S3_LOCATION_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("requestId", REQUEST_ID_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("cacheBucketOwnerId", CACHE_BUCKET_OWNER_ID_FIELD);
        }
    });
    private final String cacheBehavior;
    private final String cacheS3Location;
    private final String description;
    private final String name;
    private final String requestIdValue;
    private final Map<String, String> tags;
    private final String cacheBucketOwnerId;

    private CreateRunCacheRequest(BuilderImpl builder) {
        super(builder);
        this.cacheBehavior = builder.cacheBehavior;
        this.cacheS3Location = builder.cacheS3Location;
        this.description = builder.description;
        this.name = builder.name;
        this.requestIdValue = builder.requestIdValue;
        this.tags = builder.tags;
        this.cacheBucketOwnerId = builder.cacheBucketOwnerId;
    }

    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(this.cacheBehavior);
    }

    public final String cacheBehaviorAsString() {
        return this.cacheBehavior;
    }

    public final String cacheS3Location() {
        return this.cacheS3Location;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String cacheBucketOwnerId() {
        return this.cacheBucketOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBucketOwnerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRunCacheRequest)) {
            return false;
        }
        CreateRunCacheRequest other = (CreateRunCacheRequest)((Object)obj);
        return Objects.equals(this.cacheBehaviorAsString(), other.cacheBehaviorAsString()) && Objects.equals(this.cacheS3Location(), other.cacheS3Location()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requestId(), other.requestId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.cacheBucketOwnerId(), other.cacheBucketOwnerId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRunCacheRequest").add("CacheBehavior", (Object)this.cacheBehaviorAsString()).add("CacheS3Location", (Object)this.cacheS3Location()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("RequestId", (Object)this.requestId()).add("Tags", this.hasTags() ? this.tags() : null).add("CacheBucketOwnerId", (Object)this.cacheBucketOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorAsString()));
            }
            case "cacheS3Location": {
                return Optional.ofNullable(clazz.cast(this.cacheS3Location()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "cacheBucketOwnerId": {
                return Optional.ofNullable(clazz.cast(this.cacheBucketOwnerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRunCacheRequest, T> g) {
        return obj -> g.apply((CreateRunCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String cacheBehavior;
        private String cacheS3Location;
        private String description;
        private String name;
        private String requestIdValue;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String cacheBucketOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRunCacheRequest model) {
            super(model);
            this.cacheBehavior(model.cacheBehavior);
            this.cacheS3Location(model.cacheS3Location);
            this.description(model.description);
            this.name(model.name);
            this.requestId(model.requestIdValue);
            this.tags(model.tags);
            this.cacheBucketOwnerId(model.cacheBucketOwnerId);
        }

        public final String getCacheBehavior() {
            return this.cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getCacheS3Location() {
            return this.cacheS3Location;
        }

        public final void setCacheS3Location(String cacheS3Location) {
            this.cacheS3Location = cacheS3Location;
        }

        @Override
        public final Builder cacheS3Location(String cacheS3Location) {
            this.cacheS3Location = cacheS3Location;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getCacheBucketOwnerId() {
            return this.cacheBucketOwnerId;
        }

        public final void setCacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
        }

        @Override
        public final Builder cacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRunCacheRequest build() {
            return new CreateRunCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRunCacheRequest> {
        public Builder cacheBehavior(String var1);

        public Builder cacheBehavior(CacheBehavior var1);

        public Builder cacheS3Location(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder requestId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder cacheBucketOwnerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

