/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItem;
import software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItemsCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnnotationStoreVersionsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListAnnotationStoreVersionsResponse> {
    private static final SdkField<List<AnnotationStoreVersionItem>> ANNOTATION_STORE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("annotationStoreVersions").getter(ListAnnotationStoreVersionsResponse.getter(ListAnnotationStoreVersionsResponse::annotationStoreVersions)).setter(ListAnnotationStoreVersionsResponse.setter(Builder::annotationStoreVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationStoreVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnnotationStoreVersionItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAnnotationStoreVersionsResponse.getter(ListAnnotationStoreVersionsResponse::nextToken)).setter(ListAnnotationStoreVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_STORE_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AnnotationStoreVersionItem> annotationStoreVersions;
    private final String nextToken;

    private ListAnnotationStoreVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.annotationStoreVersions = builder.annotationStoreVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnnotationStoreVersions() {
        return this.annotationStoreVersions != null && !(this.annotationStoreVersions instanceof SdkAutoConstructList);
    }

    public final List<AnnotationStoreVersionItem> annotationStoreVersions() {
        return this.annotationStoreVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotationStoreVersions() ? this.annotationStoreVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnnotationStoreVersionsResponse)) {
            return false;
        }
        ListAnnotationStoreVersionsResponse other = (ListAnnotationStoreVersionsResponse)((Object)obj);
        return this.hasAnnotationStoreVersions() == other.hasAnnotationStoreVersions() && Objects.equals(this.annotationStoreVersions(), other.annotationStoreVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnnotationStoreVersionsResponse").add("AnnotationStoreVersions", this.hasAnnotationStoreVersions() ? this.annotationStoreVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "annotationStoreVersions": {
                return Optional.ofNullable(clazz.cast(this.annotationStoreVersions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnnotationStoreVersionsResponse, T> g) {
        return obj -> g.apply((ListAnnotationStoreVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private List<AnnotationStoreVersionItem> annotationStoreVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnnotationStoreVersionsResponse model) {
            super(model);
            this.annotationStoreVersions(model.annotationStoreVersions);
            this.nextToken(model.nextToken);
        }

        public final List<AnnotationStoreVersionItem.Builder> getAnnotationStoreVersions() {
            List<AnnotationStoreVersionItem.Builder> result = AnnotationStoreVersionItemsCopier.copyToBuilder(this.annotationStoreVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotationStoreVersions(Collection<AnnotationStoreVersionItem.BuilderImpl> annotationStoreVersions) {
            this.annotationStoreVersions = AnnotationStoreVersionItemsCopier.copyFromBuilder(annotationStoreVersions);
        }

        @Override
        public final Builder annotationStoreVersions(Collection<AnnotationStoreVersionItem> annotationStoreVersions) {
            this.annotationStoreVersions = AnnotationStoreVersionItemsCopier.copy(annotationStoreVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationStoreVersions(AnnotationStoreVersionItem ... annotationStoreVersions) {
            this.annotationStoreVersions(Arrays.asList(annotationStoreVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationStoreVersions(Consumer<AnnotationStoreVersionItem.Builder> ... annotationStoreVersions) {
            this.annotationStoreVersions(Stream.of(annotationStoreVersions).map(c -> (AnnotationStoreVersionItem)((AnnotationStoreVersionItem.Builder)AnnotationStoreVersionItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnnotationStoreVersionsResponse build() {
            return new ListAnnotationStoreVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnnotationStoreVersionsResponse> {
        public Builder annotationStoreVersions(Collection<AnnotationStoreVersionItem> var1);

        public Builder annotationStoreVersions(AnnotationStoreVersionItem ... var1);

        public Builder annotationStoreVersions(Consumer<AnnotationStoreVersionItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

