/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;

public class ListReadSetExportJobsIterable
implements SdkIterable<ListReadSetExportJobsResponse> {
    private final OmicsClient client;
    private final ListReadSetExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReadSetExportJobsIterable(OmicsClient client, ListReadSetExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReadSetExportJobsResponseFetcher();
    }

    public Iterator<ListReadSetExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportReadSetJobDetail> exportJobs() {
        Function<ListReadSetExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exportJobs() != null) {
                return response.exportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReadSetExportJobsResponseFetcher
    implements SyncPageFetcher<ListReadSetExportJobsResponse> {
        private ListReadSetExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReadSetExportJobsResponse nextPage(ListReadSetExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetExportJobsIterable.this.client.listReadSetExportJobs(ListReadSetExportJobsIterable.this.firstRequest);
            }
            return ListReadSetExportJobsIterable.this.client.listReadSetExportJobs((ListReadSetExportJobsRequest)((Object)ListReadSetExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

