/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.AnnotationFieldMapCopier;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.VariantImportItemSource;
import software.amazon.awssdk.services.omics.model.VariantImportItemSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartVariantImportJobRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, StartVariantImportJobRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationName").getter(StartVariantImportJobRequest.getter(StartVariantImportJobRequest::destinationName)).setter(StartVariantImportJobRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartVariantImportJobRequest.getter(StartVariantImportJobRequest::roleArn)).setter(StartVariantImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<VariantImportItemSource>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(StartVariantImportJobRequest.getter(StartVariantImportJobRequest::items)).setter(StartVariantImportJobRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariantImportItemSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("runLeftNormalization").getter(StartVariantImportJobRequest.getter(StartVariantImportJobRequest::runLeftNormalization)).setter(StartVariantImportJobRequest.setter(Builder::runLeftNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build()}).build();
    private static final SdkField<Map<String, String>> ANNOTATION_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("annotationFields").getter(StartVariantImportJobRequest.getter(StartVariantImportJobRequest::annotationFields)).setter(StartVariantImportJobRequest.setter(Builder::annotationFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD, ROLE_ARN_FIELD, ITEMS_FIELD, RUN_LEFT_NORMALIZATION_FIELD, ANNOTATION_FIELDS_FIELD));
    private final String destinationName;
    private final String roleArn;
    private final List<VariantImportItemSource> items;
    private final Boolean runLeftNormalization;
    private final Map<String, String> annotationFields;

    private StartVariantImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.roleArn = builder.roleArn;
        this.items = builder.items;
        this.runLeftNormalization = builder.runLeftNormalization;
        this.annotationFields = builder.annotationFields;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<VariantImportItemSource> items() {
        return this.items;
    }

    public final Boolean runLeftNormalization() {
        return this.runLeftNormalization;
    }

    public final boolean hasAnnotationFields() {
        return this.annotationFields != null && !(this.annotationFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> annotationFields() {
        return this.annotationFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runLeftNormalization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotationFields() ? this.annotationFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVariantImportJobRequest)) {
            return false;
        }
        StartVariantImportJobRequest other = (StartVariantImportJobRequest)((Object)obj);
        return Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.runLeftNormalization(), other.runLeftNormalization()) && this.hasAnnotationFields() == other.hasAnnotationFields() && Objects.equals(this.annotationFields(), other.annotationFields());
    }

    public final String toString() {
        return ToString.builder((String)"StartVariantImportJobRequest").add("DestinationName", (Object)this.destinationName()).add("RoleArn", (Object)this.roleArn()).add("Items", this.hasItems() ? this.items() : null).add("RunLeftNormalization", (Object)this.runLeftNormalization()).add("AnnotationFields", this.hasAnnotationFields() ? this.annotationFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "runLeftNormalization": {
                return Optional.ofNullable(clazz.cast(this.runLeftNormalization()));
            }
            case "annotationFields": {
                return Optional.ofNullable(clazz.cast(this.annotationFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartVariantImportJobRequest, T> g) {
        return obj -> g.apply((StartVariantImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String destinationName;
        private String roleArn;
        private List<VariantImportItemSource> items = DefaultSdkAutoConstructList.getInstance();
        private Boolean runLeftNormalization;
        private Map<String, String> annotationFields = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartVariantImportJobRequest model) {
            super(model);
            this.destinationName(model.destinationName);
            this.roleArn(model.roleArn);
            this.items(model.items);
            this.runLeftNormalization(model.runLeftNormalization);
            this.annotationFields(model.annotationFields);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<VariantImportItemSource.Builder> getItems() {
            List<VariantImportItemSource.Builder> result = VariantImportItemSourcesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<VariantImportItemSource.BuilderImpl> items) {
            this.items = VariantImportItemSourcesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<VariantImportItemSource> items) {
            this.items = VariantImportItemSourcesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(VariantImportItemSource ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<VariantImportItemSource.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (VariantImportItemSource)((VariantImportItemSource.Builder)VariantImportItemSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return this.runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        public final Map<String, String> getAnnotationFields() {
            if (this.annotationFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.annotationFields;
        }

        public final void setAnnotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
        }

        @Override
        public final Builder annotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartVariantImportJobRequest build() {
            return new StartVariantImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartVariantImportJobRequest> {
        public Builder destinationName(String var1);

        public Builder roleArn(String var1);

        public Builder items(Collection<VariantImportItemSource> var1);

        public Builder items(VariantImportItemSource ... var1);

        public Builder items(Consumer<VariantImportItemSource.Builder> ... var1);

        public Builder runLeftNormalization(Boolean var1);

        public Builder annotationFields(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

