/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StoreFormat {
    GFF("GFF"),
    TSV("TSV"),
    VCF("VCF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StoreFormat> VALUE_MAP;
    private final String value;

    private StoreFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StoreFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StoreFormat> knownValues() {
        EnumSet<StoreFormat> knownValues = EnumSet.allOf(StoreFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StoreFormat.class, StoreFormat::toString);
    }
}

