/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileInformation> {
    private static final SdkField<Integer> TOTAL_PARTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalParts").getter(FileInformation.getter(FileInformation::totalParts)).setter(FileInformation.setter(Builder::totalParts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalParts").build()}).build();
    private static final SdkField<Long> PART_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("partSize").getter(FileInformation.getter(FileInformation::partSize)).setter(FileInformation.setter(Builder::partSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSize").build()}).build();
    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("contentLength").getter(FileInformation.getter(FileInformation::contentLength)).setter(FileInformation.setter(Builder::contentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_PARTS_FIELD, PART_SIZE_FIELD, CONTENT_LENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalParts;
    private final Long partSize;
    private final Long contentLength;

    private FileInformation(BuilderImpl builder) {
        this.totalParts = builder.totalParts;
        this.partSize = builder.partSize;
        this.contentLength = builder.contentLength;
    }

    public final Integer totalParts() {
        return this.totalParts;
    }

    public final Long partSize() {
        return this.partSize;
    }

    public final Long contentLength() {
        return this.contentLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalParts());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileInformation)) {
            return false;
        }
        FileInformation other = (FileInformation)obj;
        return Objects.equals(this.totalParts(), other.totalParts()) && Objects.equals(this.partSize(), other.partSize()) && Objects.equals(this.contentLength(), other.contentLength());
    }

    public final String toString() {
        return ToString.builder((String)"FileInformation").add("TotalParts", (Object)this.totalParts()).add("PartSize", (Object)this.partSize()).add("ContentLength", (Object)this.contentLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalParts": {
                return Optional.ofNullable(clazz.cast(this.totalParts()));
            }
            case "partSize": {
                return Optional.ofNullable(clazz.cast(this.partSize()));
            }
            case "contentLength": {
                return Optional.ofNullable(clazz.cast(this.contentLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileInformation, T> g) {
        return obj -> g.apply((FileInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalParts;
        private Long partSize;
        private Long contentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(FileInformation model) {
            this.totalParts(model.totalParts);
            this.partSize(model.partSize);
            this.contentLength(model.contentLength);
        }

        public final Integer getTotalParts() {
            return this.totalParts;
        }

        public final void setTotalParts(Integer totalParts) {
            this.totalParts = totalParts;
        }

        @Override
        public final Builder totalParts(Integer totalParts) {
            this.totalParts = totalParts;
            return this;
        }

        public final Long getPartSize() {
            return this.partSize;
        }

        public final void setPartSize(Long partSize) {
            this.partSize = partSize;
        }

        @Override
        public final Builder partSize(Long partSize) {
            this.partSize = partSize;
            return this;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public FileInformation build() {
            return new FileInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileInformation> {
        public Builder totalParts(Integer var1);

        public Builder partSize(Long var1);

        public Builder contentLength(Long var1);
    }
}

