/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.omics.model.WorkflowListItem;

public class ListWorkflowsIterable
implements SdkIterable<ListWorkflowsResponse> {
    private final OmicsClient client;
    private final ListWorkflowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowsIterable(OmicsClient client, ListWorkflowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowsResponseFetcher();
    }

    public Iterator<ListWorkflowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowListItem> items() {
        Function<ListWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowsResponseFetcher
    implements SyncPageFetcher<ListWorkflowsResponse> {
        private ListWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowsResponse nextPage(ListWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowsIterable.this.client.listWorkflows(ListWorkflowsIterable.this.firstRequest);
            }
            return ListWorkflowsIterable.this.client.listWorkflows((ListWorkflowsRequest)((Object)ListWorkflowsIterable.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

