/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItem;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse;

public class ListAnnotationStoreVersionsIterable
implements SdkIterable<ListAnnotationStoreVersionsResponse> {
    private final OmicsClient client;
    private final ListAnnotationStoreVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnnotationStoreVersionsIterable(OmicsClient client, ListAnnotationStoreVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnnotationStoreVersionsResponseFetcher();
    }

    public Iterator<ListAnnotationStoreVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnnotationStoreVersionItem> annotationStoreVersions() {
        Function<ListAnnotationStoreVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.annotationStoreVersions() != null) {
                return response.annotationStoreVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnnotationStoreVersionsResponseFetcher
    implements SyncPageFetcher<ListAnnotationStoreVersionsResponse> {
        private ListAnnotationStoreVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnnotationStoreVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnnotationStoreVersionsResponse nextPage(ListAnnotationStoreVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAnnotationStoreVersionsIterable.this.client.listAnnotationStoreVersions(ListAnnotationStoreVersionsIterable.this.firstRequest);
            }
            return ListAnnotationStoreVersionsIterable.this.client.listAnnotationStoreVersions((ListAnnotationStoreVersionsRequest)((Object)ListAnnotationStoreVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

