/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.omics.DefaultOmicsBaseClientBuilder;
import software.amazon.awssdk.services.omics.DefaultOmicsClient;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.OmicsClientBuilder;
import software.amazon.awssdk.services.omics.OmicsServiceClientConfiguration;
import software.amazon.awssdk.services.omics.endpoints.OmicsEndpointProvider;

@SdkInternalApi
final class DefaultOmicsClientBuilder
extends DefaultOmicsBaseClientBuilder<OmicsClientBuilder, OmicsClient>
implements OmicsClientBuilder {
    DefaultOmicsClientBuilder() {
    }

    @Override
    public DefaultOmicsClientBuilder endpointProvider(OmicsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OmicsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOmicsClientBuilder.validateClientOptions(clientConfiguration);
        OmicsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOmicsClient client = new DefaultOmicsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OmicsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OmicsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

