/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateWorkflowRequest.Builder, CreateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkflowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("engine")
            .getter(getter(CreateWorkflowRequest::engineAsString)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()).build();

    private static final SdkField<SdkBytes> DEFINITION_ZIP_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("definitionZip").getter(getter(CreateWorkflowRequest::definitionZip))
            .setter(setter(Builder::definitionZip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionZip").build()).build();

    private static final SdkField<String> DEFINITION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definitionUri").getter(getter(CreateWorkflowRequest::definitionUri))
            .setter(setter(Builder::definitionUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionUri").build()).build();

    private static final SdkField<String> MAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("main")
            .getter(getter(CreateWorkflowRequest::main)).setter(setter(Builder::main))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()).build();

    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField
            .<Map<String, WorkflowParameter>> builder(MarshallingType.MAP)
            .memberName("parameterTemplate")
            .getter(getter(CreateWorkflowRequest::parameterTemplate))
            .setter(setter(Builder::parameterTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<WorkflowParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(CreateWorkflowRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateWorkflowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestId")
            .getter(getter(CreateWorkflowRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accelerators").getter(getter(CreateWorkflowRequest::acceleratorsAsString))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ENGINE_FIELD, DEFINITION_ZIP_FIELD, DEFINITION_URI_FIELD, MAIN_FIELD, PARAMETER_TEMPLATE_FIELD,
            STORAGE_CAPACITY_FIELD, TAGS_FIELD, REQUEST_ID_FIELD, ACCELERATORS_FIELD));

    private final String name;

    private final String description;

    private final String engine;

    private final SdkBytes definitionZip;

    private final String definitionUri;

    private final String main;

    private final Map<String, WorkflowParameter> parameterTemplate;

    private final Integer storageCapacity;

    private final Map<String, String> tags;

    private final String requestIdValue;

    private final String accelerators;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.engine = builder.engine;
        this.definitionZip = builder.definitionZip;
        this.definitionUri = builder.definitionUri;
        this.main = builder.main;
        this.parameterTemplate = builder.parameterTemplate;
        this.storageCapacity = builder.storageCapacity;
        this.tags = builder.tags;
        this.requestIdValue = builder.requestIdValue;
        this.accelerators = builder.accelerators;
    }

    /**
     * <p>
     * A name for the workflow.
     * </p>
     * 
     * @return A name for the workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the workflow.
     * </p>
     * 
     * @return A description for the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An engine for the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return An engine for the workflow.
     * @see WorkflowEngine
     */
    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(engine);
    }

    /**
     * <p>
     * An engine for the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return An engine for the workflow.
     * @see WorkflowEngine
     */
    public final String engineAsString() {
        return engine;
    }

    /**
     * <p>
     * A ZIP archive for the workflow.
     * </p>
     * 
     * @return A ZIP archive for the workflow.
     */
    public final SdkBytes definitionZip() {
        return definitionZip;
    }

    /**
     * <p>
     * The URI of a definition for the workflow.
     * </p>
     * 
     * @return The URI of a definition for the workflow.
     */
    public final String definitionUri() {
        return definitionUri;
    }

    /**
     * <p>
     * The path of the main definition file for the workflow.
     * </p>
     * 
     * @return The path of the main definition file for the workflow.
     */
    public final String main() {
        return main;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterTemplate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterTemplate() {
        return parameterTemplate != null && !(parameterTemplate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A parameter template for the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterTemplate} method.
     * </p>
     * 
     * @return A parameter template for the workflow.
     */
    public final Map<String, WorkflowParameter> parameterTemplate() {
        return parameterTemplate;
    }

    /**
     * <p>
     * A storage capacity for the workflow in gigabytes.
     * </p>
     * 
     * @return A storage capacity for the workflow in gigabytes.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the workflow.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * To ensure that requests don't run multiple times, specify a unique ID for each request.
     * </p>
     * 
     * @return To ensure that requests don't run multiple times, specify a unique ID for each request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The computational accelerator specified to run the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator specified to run the workflow.
     * @see Accelerators
     */
    public final Accelerators accelerators() {
        return Accelerators.fromValue(accelerators);
    }

    /**
     * <p>
     * The computational accelerator specified to run the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator specified to run the workflow.
     * @see Accelerators
     */
    public final String acceleratorsAsString() {
        return accelerators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(definitionZip());
        hashCode = 31 * hashCode + Objects.hashCode(definitionUri());
        hashCode = 31 * hashCode + Objects.hashCode(main());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterTemplate() ? parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(engineAsString(), other.engineAsString())
                && Objects.equals(definitionZip(), other.definitionZip())
                && Objects.equals(definitionUri(), other.definitionUri()) && Objects.equals(main(), other.main())
                && hasParameterTemplate() == other.hasParameterTemplate()
                && Objects.equals(parameterTemplate(), other.parameterTemplate())
                && Objects.equals(storageCapacity(), other.storageCapacity()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(acceleratorsAsString(), other.acceleratorsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowRequest").add("Name", name()).add("Description", description())
                .add("Engine", engineAsString()).add("DefinitionZip", definitionZip()).add("DefinitionUri", definitionUri())
                .add("Main", main()).add("ParameterTemplate", hasParameterTemplate() ? parameterTemplate() : null)
                .add("StorageCapacity", storageCapacity()).add("Tags", hasTags() ? tags() : null).add("RequestId", requestId())
                .add("Accelerators", acceleratorsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engine":
            return Optional.ofNullable(clazz.cast(engineAsString()));
        case "definitionZip":
            return Optional.ofNullable(clazz.cast(definitionZip()));
        case "definitionUri":
            return Optional.ofNullable(clazz.cast(definitionUri()));
        case "main":
            return Optional.ofNullable(clazz.cast(main()));
        case "parameterTemplate":
            return Optional.ofNullable(clazz.cast(parameterTemplate()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "accelerators":
            return Optional.ofNullable(clazz.cast(acceleratorsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkflowRequest> {
        /**
         * <p>
         * A name for the workflow.
         * </p>
         * 
         * @param name
         *        A name for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the workflow.
         * </p>
         * 
         * @param description
         *        A description for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An engine for the workflow.
         * </p>
         * 
         * @param engine
         *        An engine for the workflow.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(String engine);

        /**
         * <p>
         * An engine for the workflow.
         * </p>
         * 
         * @param engine
         *        An engine for the workflow.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(WorkflowEngine engine);

        /**
         * <p>
         * A ZIP archive for the workflow.
         * </p>
         * 
         * @param definitionZip
         *        A ZIP archive for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionZip(SdkBytes definitionZip);

        /**
         * <p>
         * The URI of a definition for the workflow.
         * </p>
         * 
         * @param definitionUri
         *        The URI of a definition for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionUri(String definitionUri);

        /**
         * <p>
         * The path of the main definition file for the workflow.
         * </p>
         * 
         * @param main
         *        The path of the main definition file for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder main(String main);

        /**
         * <p>
         * A parameter template for the workflow.
         * </p>
         * 
         * @param parameterTemplate
         *        A parameter template for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate);

        /**
         * <p>
         * A storage capacity for the workflow in gigabytes.
         * </p>
         * 
         * @param storageCapacity
         *        A storage capacity for the workflow in gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * Tags for the workflow.
         * </p>
         * 
         * @param tags
         *        Tags for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * To ensure that requests don't run multiple times, specify a unique ID for each request.
         * </p>
         * 
         * @param requestIdValue
         *        To ensure that requests don't run multiple times, specify a unique ID for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The computational accelerator specified to run the workflow.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator specified to run the workflow.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(String accelerators);

        /**
         * <p>
         * The computational accelerator specified to run the workflow.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator specified to run the workflow.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(Accelerators accelerators);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String engine;

        private SdkBytes definitionZip;

        private String definitionUri;

        private String main;

        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();

        private Integer storageCapacity;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String requestIdValue;

        private String accelerators;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            engine(model.engine);
            definitionZip(model.definitionZip);
            definitionUri(model.definitionUri);
            main(model.main);
            parameterTemplate(model.parameterTemplate);
            storageCapacity(model.storageCapacity);
            tags(model.tags);
            requestId(model.requestIdValue);
            accelerators(model.accelerators);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final ByteBuffer getDefinitionZip() {
            return definitionZip == null ? null : definitionZip.asByteBuffer();
        }

        public final void setDefinitionZip(ByteBuffer definitionZip) {
            definitionZip(definitionZip == null ? null : SdkBytes.fromByteBuffer(definitionZip));
        }

        @Override
        public final Builder definitionZip(SdkBytes definitionZip) {
            this.definitionZip = definitionZip;
            return this;
        }

        public final String getDefinitionUri() {
            return definitionUri;
        }

        public final void setDefinitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
        }

        @Override
        public final Builder definitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        public final String getMain() {
            return main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getAccelerators() {
            return accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
