/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem;

public class ListReadSetUploadPartsPublisher
implements SdkPublisher<ListReadSetUploadPartsResponse> {
    private final OmicsAsyncClient client;
    private final ListReadSetUploadPartsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReadSetUploadPartsPublisher(OmicsAsyncClient client, ListReadSetUploadPartsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReadSetUploadPartsPublisher(OmicsAsyncClient client, ListReadSetUploadPartsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReadSetUploadPartsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReadSetUploadPartsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReadSetUploadPartListItem> parts() {
        Function<ListReadSetUploadPartsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parts() != null) {
                return response.parts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReadSetUploadPartsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReadSetUploadPartsResponseFetcher
    implements AsyncPageFetcher<ListReadSetUploadPartsResponse> {
        private ListReadSetUploadPartsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetUploadPartsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReadSetUploadPartsResponse> nextPage(ListReadSetUploadPartsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetUploadPartsPublisher.this.client.listReadSetUploadParts(ListReadSetUploadPartsPublisher.this.firstRequest);
            }
            return ListReadSetUploadPartsPublisher.this.client.listReadSetUploadParts((ListReadSetUploadPartsRequest)((Object)ListReadSetUploadPartsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

