/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;

public class ListReadSetActivationJobsPublisher
implements SdkPublisher<ListReadSetActivationJobsResponse> {
    private final OmicsAsyncClient client;
    private final ListReadSetActivationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReadSetActivationJobsPublisher(OmicsAsyncClient client, ListReadSetActivationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReadSetActivationJobsPublisher(OmicsAsyncClient client, ListReadSetActivationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReadSetActivationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReadSetActivationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActivateReadSetJobItem> activationJobs() {
        Function<ListReadSetActivationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.activationJobs() != null) {
                return response.activationJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReadSetActivationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReadSetActivationJobsResponseFetcher
    implements AsyncPageFetcher<ListReadSetActivationJobsResponse> {
        private ListReadSetActivationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetActivationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReadSetActivationJobsResponse> nextPage(ListReadSetActivationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetActivationJobsPublisher.this.client.listReadSetActivationJobs(ListReadSetActivationJobsPublisher.this.firstRequest);
            }
            return ListReadSetActivationJobsPublisher.this.client.listReadSetActivationJobs((ListReadSetActivationJobsRequest)((Object)ListReadSetActivationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

