/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ExportReadSetDetail;
import software.amazon.awssdk.services.omics.model.ExportReadSetDetailListCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetExportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadSetExportJobResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetReadSetExportJobResponse> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::completionTime)).setter(GetReadSetExportJobResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::creationTime)).setter(GetReadSetExportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::destination)).setter(GetReadSetExportJobResponse.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::id)).setter(GetReadSetExportJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<ExportReadSetDetail>> READ_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("readSets").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::readSets)).setter(GetReadSetExportJobResponse.setter(Builder::readSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportReadSetDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::sequenceStoreId)).setter(GetReadSetExportJobResponse.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::statusAsString)).setter(GetReadSetExportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetReadSetExportJobResponse.getter(GetReadSetExportJobResponse::statusMessage)).setter(GetReadSetExportJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, CREATION_TIME_FIELD, DESTINATION_FIELD, ID_FIELD, READ_SETS_FIELD, SEQUENCE_STORE_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private final Instant completionTime;
    private final Instant creationTime;
    private final String destination;
    private final String id;
    private final List<ExportReadSetDetail> readSets;
    private final String sequenceStoreId;
    private final String status;
    private final String statusMessage;

    private GetReadSetExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.completionTime = builder.completionTime;
        this.creationTime = builder.creationTime;
        this.destination = builder.destination;
        this.id = builder.id;
        this.readSets = builder.readSets;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String destination() {
        return this.destination;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasReadSets() {
        return this.readSets != null && !(this.readSets instanceof SdkAutoConstructList);
    }

    public final List<ExportReadSetDetail> readSets() {
        return this.readSets;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final ReadSetExportJobStatus status() {
        return ReadSetExportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadSets() ? this.readSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadSetExportJobResponse)) {
            return false;
        }
        GetReadSetExportJobResponse other = (GetReadSetExportJobResponse)((Object)obj);
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.id(), other.id()) && this.hasReadSets() == other.hasReadSets() && Objects.equals(this.readSets(), other.readSets()) && Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadSetExportJobResponse").add("CompletionTime", (Object)this.completionTime()).add("CreationTime", (Object)this.creationTime()).add("Destination", (Object)this.destination()).add("Id", (Object)this.id()).add("ReadSets", this.hasReadSets() ? this.readSets() : null).add("SequenceStoreId", (Object)this.sequenceStoreId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "readSets": {
                return Optional.ofNullable(clazz.cast(this.readSets()));
            }
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadSetExportJobResponse, T> g) {
        return obj -> g.apply((GetReadSetExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private Instant completionTime;
        private Instant creationTime;
        private String destination;
        private String id;
        private List<ExportReadSetDetail> readSets = DefaultSdkAutoConstructList.getInstance();
        private String sequenceStoreId;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadSetExportJobResponse model) {
            super(model);
            this.completionTime(model.completionTime);
            this.creationTime(model.creationTime);
            this.destination(model.destination);
            this.id(model.id);
            this.readSets(model.readSets);
            this.sequenceStoreId(model.sequenceStoreId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<ExportReadSetDetail.Builder> getReadSets() {
            List<ExportReadSetDetail.Builder> result = ExportReadSetDetailListCopier.copyToBuilder(this.readSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadSets(Collection<ExportReadSetDetail.BuilderImpl> readSets) {
            this.readSets = ExportReadSetDetailListCopier.copyFromBuilder(readSets);
        }

        @Override
        public final Builder readSets(Collection<ExportReadSetDetail> readSets) {
            this.readSets = ExportReadSetDetailListCopier.copy(readSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readSets(ExportReadSetDetail ... readSets) {
            this.readSets(Arrays.asList(readSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readSets(Consumer<ExportReadSetDetail.Builder> ... readSets) {
            this.readSets(Stream.of(readSets).map(c -> (ExportReadSetDetail)((ExportReadSetDetail.Builder)ExportReadSetDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public GetReadSetExportJobResponse build() {
            return new GetReadSetExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadSetExportJobResponse> {
        public Builder completionTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder destination(String var1);

        public Builder id(String var1);

        public Builder readSets(Collection<ExportReadSetDetail> var1);

        public Builder readSets(ExportReadSetDetail ... var1);

        public Builder readSets(Consumer<ExportReadSetDetail.Builder> ... var1);

        public Builder sequenceStoreId(String var1);

        public Builder status(String var1);

        public Builder status(ReadSetExportJobStatus var1);

        public Builder statusMessage(String var1);
    }
}

