/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ImportReadSetJobItem;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;

public class ListReadSetImportJobsIterable
implements SdkIterable<ListReadSetImportJobsResponse> {
    private final OmicsClient client;
    private final ListReadSetImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReadSetImportJobsIterable(OmicsClient client, ListReadSetImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReadSetImportJobsResponseFetcher();
    }

    public Iterator<ListReadSetImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportReadSetJobItem> importJobs() {
        Function<ListReadSetImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobs() != null) {
                return response.importJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReadSetImportJobsResponseFetcher
    implements SyncPageFetcher<ListReadSetImportJobsResponse> {
        private ListReadSetImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReadSetImportJobsResponse nextPage(ListReadSetImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetImportJobsIterable.this.client.listReadSetImportJobs(ListReadSetImportJobsIterable.this.firstRequest);
            }
            return ListReadSetImportJobsIterable.this.client.listReadSetImportJobs((ListReadSetImportJobsRequest)((Object)ListReadSetImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

