/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.WorkflowExport;
import software.amazon.awssdk.services.omics.model.WorkflowExportListCopier;
import software.amazon.awssdk.services.omics.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, GetWorkflowRequest> {
    private static final SdkField<List<String>> EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("export").getter(GetWorkflowRequest.getter(GetWorkflowRequest::exportAsStrings)).setter(GetWorkflowRequest.setter(Builder::exportWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("export").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetWorkflowRequest.getter(GetWorkflowRequest::id)).setter(GetWorkflowRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetWorkflowRequest.getter(GetWorkflowRequest::typeAsString)).setter(GetWorkflowRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FIELD, ID_FIELD, TYPE_FIELD));
    private final List<String> export;
    private final String id;
    private final String type;

    private GetWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.export = builder.export;
        this.id = builder.id;
        this.type = builder.type;
    }

    public final List<WorkflowExport> export() {
        return WorkflowExportListCopier.copyStringToEnum(this.export);
    }

    public final boolean hasExport() {
        return this.export != null && !(this.export instanceof SdkAutoConstructList);
    }

    public final List<String> exportAsStrings() {
        return this.export;
    }

    public final String id() {
        return this.id;
    }

    public final WorkflowType type() {
        return WorkflowType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExport() ? this.exportAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRequest)) {
            return false;
        }
        GetWorkflowRequest other = (GetWorkflowRequest)((Object)obj);
        return this.hasExport() == other.hasExport() && Objects.equals(this.exportAsStrings(), other.exportAsStrings()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowRequest").add("Export", this.hasExport() ? this.exportAsStrings() : null).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "export": {
                return Optional.ofNullable(clazz.cast(this.exportAsStrings()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRequest, T> g) {
        return obj -> g.apply((GetWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private List<String> export = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRequest model) {
            super(model);
            this.exportWithStrings(model.export);
            this.id(model.id);
            this.type(model.type);
        }

        public final Collection<String> getExport() {
            if (this.export instanceof SdkAutoConstructList) {
                return null;
            }
            return this.export;
        }

        public final void setExport(Collection<String> export) {
            this.export = WorkflowExportListCopier.copy(export);
        }

        @Override
        public final Builder exportWithStrings(Collection<String> export) {
            this.export = WorkflowExportListCopier.copy(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportWithStrings(String ... export) {
            this.exportWithStrings(Arrays.asList(export));
            return this;
        }

        @Override
        public final Builder export(Collection<WorkflowExport> export) {
            this.export = WorkflowExportListCopier.copyEnumToString(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder export(WorkflowExport ... export) {
            this.export(Arrays.asList(export));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkflowRequest build() {
            return new GetWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowRequest> {
        public Builder exportWithStrings(Collection<String> var1);

        public Builder exportWithStrings(String ... var1);

        public Builder export(Collection<WorkflowExport> var1);

        public Builder export(WorkflowExport ... var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(WorkflowType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

