/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReadSetStatus {
    ARCHIVED("ARCHIVED"),
    ACTIVATING("ACTIVATING"),
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReadSetStatus> VALUE_MAP;
    private final String value;

    private ReadSetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReadSetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReadSetStatus> knownValues() {
        EnumSet<ReadSetStatus> knownValues = EnumSet.allOf(ReadSetStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReadSetStatus.class, ReadSetStatus::toString);
    }
}

