/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem;
import software.amazon.awssdk.services.omics.model.ImportReferenceSourceListCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReferenceImportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReferenceImportJobResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetReferenceImportJobResponse> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::completionTime)).setter(GetReferenceImportJobResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::creationTime)).setter(GetReferenceImportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::id)).setter(GetReferenceImportJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> REFERENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceStoreId").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::referenceStoreId)).setter(GetReferenceImportJobResponse.setter(Builder::referenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceStoreId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::roleArn)).setter(GetReferenceImportJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<ImportReferenceSourceItem>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::sources)).setter(GetReferenceImportJobResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportReferenceSourceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::statusAsString)).setter(GetReferenceImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetReferenceImportJobResponse.getter(GetReferenceImportJobResponse::statusMessage)).setter(GetReferenceImportJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, CREATION_TIME_FIELD, ID_FIELD, REFERENCE_STORE_ID_FIELD, ROLE_ARN_FIELD, SOURCES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private final Instant completionTime;
    private final Instant creationTime;
    private final String id;
    private final String referenceStoreId;
    private final String roleArn;
    private final List<ImportReferenceSourceItem> sources;
    private final String status;
    private final String statusMessage;

    private GetReferenceImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.completionTime = builder.completionTime;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.referenceStoreId = builder.referenceStoreId;
        this.roleArn = builder.roleArn;
        this.sources = builder.sources;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String referenceStoreId() {
        return this.referenceStoreId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<ImportReferenceSourceItem> sources() {
        return this.sources;
    }

    public final ReferenceImportJobStatus status() {
        return ReferenceImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReferenceImportJobResponse)) {
            return false;
        }
        GetReferenceImportJobResponse other = (GetReferenceImportJobResponse)((Object)obj);
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.referenceStoreId(), other.referenceStoreId()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"GetReferenceImportJobResponse").add("CompletionTime", (Object)this.completionTime()).add("CreationTime", (Object)this.creationTime()).add("Id", (Object)this.id()).add("ReferenceStoreId", (Object)this.referenceStoreId()).add("RoleArn", (Object)this.roleArn()).add("Sources", this.hasSources() ? this.sources() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "referenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.referenceStoreId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReferenceImportJobResponse, T> g) {
        return obj -> g.apply((GetReferenceImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private Instant completionTime;
        private Instant creationTime;
        private String id;
        private String referenceStoreId;
        private String roleArn;
        private List<ImportReferenceSourceItem> sources = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReferenceImportJobResponse model) {
            super(model);
            this.completionTime(model.completionTime);
            this.creationTime(model.creationTime);
            this.id(model.id);
            this.referenceStoreId(model.referenceStoreId);
            this.roleArn(model.roleArn);
            this.sources(model.sources);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getReferenceStoreId() {
            return this.referenceStoreId;
        }

        public final void setReferenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
        }

        @Override
        public final Builder referenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<ImportReferenceSourceItem.Builder> getSources() {
            List<ImportReferenceSourceItem.Builder> result = ImportReferenceSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<ImportReferenceSourceItem.BuilderImpl> sources) {
            this.sources = ImportReferenceSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<ImportReferenceSourceItem> sources) {
            this.sources = ImportReferenceSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(ImportReferenceSourceItem ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<ImportReferenceSourceItem.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (ImportReferenceSourceItem)((ImportReferenceSourceItem.Builder)ImportReferenceSourceItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReferenceImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public GetReferenceImportJobResponse build() {
            return new GetReferenceImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReferenceImportJobResponse> {
        public Builder completionTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder id(String var1);

        public Builder referenceStoreId(String var1);

        public Builder roleArn(String var1);

        public Builder sources(Collection<ImportReferenceSourceItem> var1);

        public Builder sources(ImportReferenceSourceItem ... var1);

        public Builder sources(Consumer<ImportReferenceSourceItem.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(ReferenceImportJobStatus var1);

        public Builder statusMessage(String var1);
    }
}

