/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ReadSetExportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportReadSetFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportReadSetFilter> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAfter").getter(ExportReadSetFilter.getter(ExportReadSetFilter::createdAfter)).setter(ExportReadSetFilter.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdBefore").getter(ExportReadSetFilter.getter(ExportReadSetFilter::createdBefore)).setter(ExportReadSetFilter.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ExportReadSetFilter.getter(ExportReadSetFilter::statusAsString)).setter(ExportReadSetFilter.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final String status;

    private ExportReadSetFilter(BuilderImpl builder) {
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.status = builder.status;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final ReadSetExportJobStatus status() {
        return ReadSetExportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportReadSetFilter)) {
            return false;
        }
        ExportReadSetFilter other = (ExportReadSetFilter)obj;
        return Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExportReadSetFilter").add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "createdBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportReadSetFilter, T> g) {
        return obj -> g.apply((ExportReadSetFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportReadSetFilter model) {
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.status(model.status);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ExportReadSetFilter build() {
            return new ExportReadSetFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportReadSetFilter> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder status(String var1);

        public Builder status(ReadSetExportJobStatus var1);
    }
}

