/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ReferenceStoreDetail;

public class ListReferenceStoresIterable
implements SdkIterable<ListReferenceStoresResponse> {
    private final OmicsClient client;
    private final ListReferenceStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReferenceStoresIterable(OmicsClient client, ListReferenceStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReferenceStoresResponseFetcher();
    }

    public Iterator<ListReferenceStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReferenceStoreDetail> referenceStores() {
        Function<ListReferenceStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.referenceStores() != null) {
                return response.referenceStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReferenceStoresResponseFetcher
    implements SyncPageFetcher<ListReferenceStoresResponse> {
        private ListReferenceStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListReferenceStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReferenceStoresResponse nextPage(ListReferenceStoresResponse previousPage) {
            if (previousPage == null) {
                return ListReferenceStoresIterable.this.client.listReferenceStores(ListReferenceStoresIterable.this.firstRequest);
            }
            return ListReferenceStoresIterable.this.client.listReferenceStores((ListReferenceStoresRequest)((Object)ListReferenceStoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

