/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;

public class ListReadSetActivationJobsIterable
implements SdkIterable<ListReadSetActivationJobsResponse> {
    private final OmicsClient client;
    private final ListReadSetActivationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReadSetActivationJobsIterable(OmicsClient client, ListReadSetActivationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReadSetActivationJobsResponseFetcher();
    }

    public Iterator<ListReadSetActivationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActivateReadSetJobItem> activationJobs() {
        Function<ListReadSetActivationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.activationJobs() != null) {
                return response.activationJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReadSetActivationJobsResponseFetcher
    implements SyncPageFetcher<ListReadSetActivationJobsResponse> {
        private ListReadSetActivationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetActivationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReadSetActivationJobsResponse nextPage(ListReadSetActivationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetActivationJobsIterable.this.client.listReadSetActivationJobs(ListReadSetActivationJobsIterable.this.firstRequest);
            }
            return ListReadSetActivationJobsIterable.this.client.listReadSetActivationJobs((ListReadSetActivationJobsRequest)((Object)ListReadSetActivationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

