/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.waiters.OmicsWaiter;
import software.amazon.awssdk.services.omics.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultOmicsWaiter
implements OmicsWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final OmicsClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetAnnotationImportJobResponse> annotationImportJobCreatedWaiter;
    private final Waiter<GetAnnotationStoreResponse> annotationStoreCreatedWaiter;
    private final Waiter<GetAnnotationStoreResponse> annotationStoreDeletedWaiter;
    private final Waiter<GetReadSetActivationJobResponse> readSetActivationJobCompletedWaiter;
    private final Waiter<GetReadSetExportJobResponse> readSetExportJobCompletedWaiter;
    private final Waiter<GetReadSetImportJobResponse> readSetImportJobCompletedWaiter;
    private final Waiter<GetReferenceImportJobResponse> referenceImportJobCompletedWaiter;
    private final Waiter<GetRunResponse> runCompletedWaiter;
    private final Waiter<GetRunResponse> runRunningWaiter;
    private final Waiter<GetRunTaskResponse> taskCompletedWaiter;
    private final Waiter<GetRunTaskResponse> taskRunningWaiter;
    private final Waiter<GetVariantImportJobResponse> variantImportJobCreatedWaiter;
    private final Waiter<GetVariantStoreResponse> variantStoreCreatedWaiter;
    private final Waiter<GetVariantStoreResponse> variantStoreDeletedWaiter;
    private final Waiter<GetWorkflowResponse> workflowActiveWaiter;

    private DefaultOmicsWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (OmicsClient)OmicsClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.annotationImportJobCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetAnnotationImportJobResponse.class).acceptors(DefaultOmicsWaiter.annotationImportJobCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.annotationImportJobCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.annotationStoreCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetAnnotationStoreResponse.class).acceptors(DefaultOmicsWaiter.annotationStoreCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.annotationStoreCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.annotationStoreDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetAnnotationStoreResponse.class).acceptors(DefaultOmicsWaiter.annotationStoreDeletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.annotationStoreDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.readSetActivationJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetReadSetActivationJobResponse.class).acceptors(DefaultOmicsWaiter.readSetActivationJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.readSetActivationJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.readSetExportJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetReadSetExportJobResponse.class).acceptors(DefaultOmicsWaiter.readSetExportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.readSetExportJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.readSetImportJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetReadSetImportJobResponse.class).acceptors(DefaultOmicsWaiter.readSetImportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.readSetImportJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.referenceImportJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetReferenceImportJobResponse.class).acceptors(DefaultOmicsWaiter.referenceImportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.referenceImportJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.runCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRunResponse.class).acceptors(DefaultOmicsWaiter.runCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.runCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.runRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRunResponse.class).acceptors(DefaultOmicsWaiter.runRunningWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.runRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.taskCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRunTaskResponse.class).acceptors(DefaultOmicsWaiter.taskCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.taskCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.taskRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRunTaskResponse.class).acceptors(DefaultOmicsWaiter.taskRunningWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.taskRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.variantImportJobCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetVariantImportJobResponse.class).acceptors(DefaultOmicsWaiter.variantImportJobCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.variantImportJobCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.variantStoreCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetVariantStoreResponse.class).acceptors(DefaultOmicsWaiter.variantStoreCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.variantStoreCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.variantStoreDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetVariantStoreResponse.class).acceptors(DefaultOmicsWaiter.variantStoreDeletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.variantStoreDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.workflowActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetWorkflowResponse.class).acceptors(DefaultOmicsWaiter.workflowActiveWaiterAcceptors())).overrideConfiguration(DefaultOmicsWaiter.workflowActiveWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        return this.annotationImportJobCreatedWaiter.run(() -> this.client.getAnnotationImportJob(this.applyWaitersUserAgent(getAnnotationImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(GetAnnotationImportJobRequest getAnnotationImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationImportJobCreatedWaiter.run(() -> this.client.getAnnotationImportJob(this.applyWaitersUserAgent(getAnnotationImportJobRequest)), DefaultOmicsWaiter.annotationImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return this.annotationStoreCreatedWaiter.run(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationStoreCreatedWaiter.run(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)), DefaultOmicsWaiter.annotationStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return this.annotationStoreDeletedWaiter.run(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationStoreDeletedWaiter.run(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)), DefaultOmicsWaiter.annotationStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        return this.readSetActivationJobCompletedWaiter.run(() -> this.client.getReadSetActivationJob(this.applyWaitersUserAgent(getReadSetActivationJobRequest)));
    }

    @Override
    public WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(GetReadSetActivationJobRequest getReadSetActivationJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.readSetActivationJobCompletedWaiter.run(() -> this.client.getReadSetActivationJob(this.applyWaitersUserAgent(getReadSetActivationJobRequest)), DefaultOmicsWaiter.readSetActivationJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(GetReadSetExportJobRequest getReadSetExportJobRequest) {
        return this.readSetExportJobCompletedWaiter.run(() -> this.client.getReadSetExportJob(this.applyWaitersUserAgent(getReadSetExportJobRequest)));
    }

    @Override
    public WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(GetReadSetExportJobRequest getReadSetExportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.readSetExportJobCompletedWaiter.run(() -> this.client.getReadSetExportJob(this.applyWaitersUserAgent(getReadSetExportJobRequest)), DefaultOmicsWaiter.readSetExportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(GetReadSetImportJobRequest getReadSetImportJobRequest) {
        return this.readSetImportJobCompletedWaiter.run(() -> this.client.getReadSetImportJob(this.applyWaitersUserAgent(getReadSetImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(GetReadSetImportJobRequest getReadSetImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.readSetImportJobCompletedWaiter.run(() -> this.client.getReadSetImportJob(this.applyWaitersUserAgent(getReadSetImportJobRequest)), DefaultOmicsWaiter.readSetImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(GetReferenceImportJobRequest getReferenceImportJobRequest) {
        return this.referenceImportJobCompletedWaiter.run(() -> this.client.getReferenceImportJob(this.applyWaitersUserAgent(getReferenceImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(GetReferenceImportJobRequest getReferenceImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.referenceImportJobCompletedWaiter.run(() -> this.client.getReferenceImportJob(this.applyWaitersUserAgent(getReferenceImportJobRequest)), DefaultOmicsWaiter.referenceImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunCompleted(GetRunRequest getRunRequest) {
        return this.runCompletedWaiter.run(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunCompleted(GetRunRequest getRunRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.runCompletedWaiter.run(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)), DefaultOmicsWaiter.runCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunRunning(GetRunRequest getRunRequest) {
        return this.runRunningWaiter.run(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunRunning(GetRunRequest getRunRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.runRunningWaiter.run(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)), DefaultOmicsWaiter.runRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest) {
        return this.taskCompletedWaiter.run(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.taskCompletedWaiter.run(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)), DefaultOmicsWaiter.taskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest) {
        return this.taskRunningWaiter.run(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.taskRunningWaiter.run(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)), DefaultOmicsWaiter.taskRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(GetVariantImportJobRequest getVariantImportJobRequest) {
        return this.variantImportJobCreatedWaiter.run(() -> this.client.getVariantImportJob(this.applyWaitersUserAgent(getVariantImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(GetVariantImportJobRequest getVariantImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.variantImportJobCreatedWaiter.run(() -> this.client.getVariantImportJob(this.applyWaitersUserAgent(getVariantImportJobRequest)), DefaultOmicsWaiter.variantImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest) {
        return this.variantStoreCreatedWaiter.run(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.variantStoreCreatedWaiter.run(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)), DefaultOmicsWaiter.variantStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest) {
        return this.variantStoreDeletedWaiter.run(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.variantStoreDeletedWaiter.run(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)), DefaultOmicsWaiter.variantStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest) {
        return this.workflowActiveWaiter.run(() -> this.client.getWorkflow(this.applyWaitersUserAgent(getWorkflowRequest)));
    }

    @Override
    public WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.workflowActiveWaiter.run(() -> this.client.getWorkflow(this.applyWaitersUserAgent(getWorkflowRequest)), DefaultOmicsWaiter.workflowActiveWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetAnnotationImportJobResponse>> annotationImportJobCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationImportJobResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultOmicsWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetActivationJobResponse>> readSetActivationJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReadSetActivationJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReadSetActivationJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetExportJobResponse>> readSetExportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReadSetExportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReadSetExportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetImportJobResponse>> readSetImportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReadSetImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReadSetImportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReferenceImportJobResponse>> referenceImportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReferenceImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReferenceImportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunTaskResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunTaskResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantImportJobResponse>> variantImportJobCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVariantImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetVariantImportJobResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultOmicsWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetWorkflowResponse>> workflowActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetWorkflowResponse>> result = new ArrayList<WaiterAcceptor<? super GetWorkflowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration annotationImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetActivationJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetExportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration referenceImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration workflowActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static OmicsWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends OmicsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OmicsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements OmicsWaiter.Builder {
        private OmicsClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public OmicsWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public OmicsWaiter.Builder client(OmicsClient client) {
            this.client = client;
            return this;
        }

        @Override
        public OmicsWaiter build() {
            return new DefaultOmicsWaiter(this);
        }
    }
}

