/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.AnnotationImportJobItem;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;

public class ListAnnotationImportJobsPublisher
implements SdkPublisher<ListAnnotationImportJobsResponse> {
    private final OmicsAsyncClient client;
    private final ListAnnotationImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnnotationImportJobsPublisher(OmicsAsyncClient client, ListAnnotationImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnnotationImportJobsPublisher(OmicsAsyncClient client, ListAnnotationImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnnotationImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnnotationImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnnotationImportJobItem> annotationImportJobs() {
        Function<ListAnnotationImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.annotationImportJobs() != null) {
                return response.annotationImportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnnotationImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnnotationImportJobsResponseFetcher
    implements AsyncPageFetcher<ListAnnotationImportJobsResponse> {
        private ListAnnotationImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnnotationImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnnotationImportJobsResponse> nextPage(ListAnnotationImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAnnotationImportJobsPublisher.this.client.listAnnotationImportJobs(ListAnnotationImportJobsPublisher.this.firstRequest);
            }
            return ListAnnotationImportJobsPublisher.this.client.listAnnotationImportJobs((ListAnnotationImportJobsRequest)((Object)ListAnnotationImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

