/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Part of the response to the CompleteReadSetUpload API, including metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteReadSetUploadPartListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CompleteReadSetUploadPartListItem.Builder, CompleteReadSetUploadPartListItem> {
    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("partNumber").getter(getter(CompleteReadSetUploadPartListItem::partNumber))
            .setter(setter(Builder::partNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partNumber").build()).build();

    private static final SdkField<String> PART_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partSource").getter(getter(CompleteReadSetUploadPartListItem::partSourceAsString))
            .setter(setter(Builder::partSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSource").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(CompleteReadSetUploadPartListItem::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PART_NUMBER_FIELD,
            PART_SOURCE_FIELD, CHECKSUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer partNumber;

    private final String partSource;

    private final String checksum;

    private CompleteReadSetUploadPartListItem(BuilderImpl builder) {
        this.partNumber = builder.partNumber;
        this.partSource = builder.partSource;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * A number identifying the part in a read set upload.
     * </p>
     * 
     * @return A number identifying the part in a read set upload.
     */
    public final Integer partNumber() {
        return partNumber;
    }

    /**
     * <p>
     * The source file of the part being uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partSource} will
     * return {@link ReadSetPartSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partSourceAsString}.
     * </p>
     * 
     * @return The source file of the part being uploaded.
     * @see ReadSetPartSource
     */
    public final ReadSetPartSource partSource() {
        return ReadSetPartSource.fromValue(partSource);
    }

    /**
     * <p>
     * The source file of the part being uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partSource} will
     * return {@link ReadSetPartSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partSourceAsString}.
     * </p>
     * 
     * @return The source file of the part being uploaded.
     * @see ReadSetPartSource
     */
    public final String partSourceAsString() {
        return partSource;
    }

    /**
     * <p>
     * A unique identifier used to confirm that parts are being added to the correct upload.
     * </p>
     * 
     * @return A unique identifier used to confirm that parts are being added to the correct upload.
     */
    public final String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partNumber());
        hashCode = 31 * hashCode + Objects.hashCode(partSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteReadSetUploadPartListItem)) {
            return false;
        }
        CompleteReadSetUploadPartListItem other = (CompleteReadSetUploadPartListItem) obj;
        return Objects.equals(partNumber(), other.partNumber())
                && Objects.equals(partSourceAsString(), other.partSourceAsString())
                && Objects.equals(checksum(), other.checksum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteReadSetUploadPartListItem").add("PartNumber", partNumber())
                .add("PartSource", partSourceAsString()).add("Checksum", checksum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "partNumber":
            return Optional.ofNullable(clazz.cast(partNumber()));
        case "partSource":
            return Optional.ofNullable(clazz.cast(partSourceAsString()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteReadSetUploadPartListItem, T> g) {
        return obj -> g.apply((CompleteReadSetUploadPartListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompleteReadSetUploadPartListItem> {
        /**
         * <p>
         * A number identifying the part in a read set upload.
         * </p>
         * 
         * @param partNumber
         *        A number identifying the part in a read set upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);

        /**
         * <p>
         * The source file of the part being uploaded.
         * </p>
         * 
         * @param partSource
         *        The source file of the part being uploaded.
         * @see ReadSetPartSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetPartSource
         */
        Builder partSource(String partSource);

        /**
         * <p>
         * The source file of the part being uploaded.
         * </p>
         * 
         * @param partSource
         *        The source file of the part being uploaded.
         * @see ReadSetPartSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetPartSource
         */
        Builder partSource(ReadSetPartSource partSource);

        /**
         * <p>
         * A unique identifier used to confirm that parts are being added to the correct upload.
         * </p>
         * 
         * @param checksum
         *        A unique identifier used to confirm that parts are being added to the correct upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    static final class BuilderImpl implements Builder {
        private Integer partNumber;

        private String partSource;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteReadSetUploadPartListItem model) {
            partNumber(model.partNumber);
            partSource(model.partSource);
            checksum(model.checksum);
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final String getPartSource() {
            return partSource;
        }

        public final void setPartSource(String partSource) {
            this.partSource = partSource;
        }

        @Override
        public final Builder partSource(String partSource) {
            this.partSource = partSource;
            return this;
        }

        @Override
        public final Builder partSource(ReadSetPartSource partSource) {
            this.partSource(partSource == null ? null : partSource.toString());
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public CompleteReadSetUploadPartListItem build() {
            return new CompleteReadSetUploadPartListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
