/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ImportReferenceJobItem;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;

public class ListReferenceImportJobsIterable
implements SdkIterable<ListReferenceImportJobsResponse> {
    private final OmicsClient client;
    private final ListReferenceImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReferenceImportJobsIterable(OmicsClient client, ListReferenceImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReferenceImportJobsResponseFetcher();
    }

    public Iterator<ListReferenceImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportReferenceJobItem> importJobs() {
        Function<ListReferenceImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobs() != null) {
                return response.importJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReferenceImportJobsResponseFetcher
    implements SyncPageFetcher<ListReferenceImportJobsResponse> {
        private ListReferenceImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReferenceImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReferenceImportJobsResponse nextPage(ListReferenceImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReferenceImportJobsIterable.this.client.listReferenceImportJobs(ListReferenceImportJobsIterable.this.firstRequest);
            }
            return ListReferenceImportJobsIterable.this.client.listReferenceImportJobs((ListReferenceImportJobsRequest)((Object)ListReferenceImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

