/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ReadSetActivationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivateReadSetJobItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivateReadSetJobItem> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(ActivateReadSetJobItem.getter(ActivateReadSetJobItem::completionTime)).setter(ActivateReadSetJobItem.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ActivateReadSetJobItem.getter(ActivateReadSetJobItem::creationTime)).setter(ActivateReadSetJobItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ActivateReadSetJobItem.getter(ActivateReadSetJobItem::id)).setter(ActivateReadSetJobItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(ActivateReadSetJobItem.getter(ActivateReadSetJobItem::sequenceStoreId)).setter(ActivateReadSetJobItem.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ActivateReadSetJobItem.getter(ActivateReadSetJobItem::statusAsString)).setter(ActivateReadSetJobItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, CREATION_TIME_FIELD, ID_FIELD, SEQUENCE_STORE_ID_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant completionTime;
    private final Instant creationTime;
    private final String id;
    private final String sequenceStoreId;
    private final String status;

    private ActivateReadSetJobItem(BuilderImpl builder) {
        this.completionTime = builder.completionTime;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.status = builder.status;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final ReadSetActivationJobStatus status() {
        return ReadSetActivationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateReadSetJobItem)) {
            return false;
        }
        ActivateReadSetJobItem other = (ActivateReadSetJobItem)obj;
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ActivateReadSetJobItem").add("CompletionTime", (Object)this.completionTime()).add("CreationTime", (Object)this.creationTime()).add("Id", (Object)this.id()).add("SequenceStoreId", (Object)this.sequenceStoreId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateReadSetJobItem, T> g) {
        return obj -> g.apply((ActivateReadSetJobItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant completionTime;
        private Instant creationTime;
        private String id;
        private String sequenceStoreId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateReadSetJobItem model) {
            this.completionTime(model.completionTime);
            this.creationTime(model.creationTime);
            this.id(model.id);
            this.sequenceStoreId(model.sequenceStoreId);
            this.status(model.status);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetActivationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ActivateReadSetJobItem build() {
            return new ActivateReadSetJobItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivateReadSetJobItem> {
        public Builder completionTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder id(String var1);

        public Builder sequenceStoreId(String var1);

        public Builder status(String var1);

        public Builder status(ReadSetActivationJobStatus var1);
    }
}

