/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.RunExport;
import software.amazon.awssdk.services.omics.model.RunExportListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRunRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, GetRunRequest> {
    private static final SdkField<List<String>> EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("export").getter(GetRunRequest.getter(GetRunRequest::exportAsStrings)).setter(GetRunRequest.setter(Builder::exportWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("export").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetRunRequest.getter(GetRunRequest::id)).setter(GetRunRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FIELD, ID_FIELD));
    private final List<String> export;
    private final String id;

    private GetRunRequest(BuilderImpl builder) {
        super(builder);
        this.export = builder.export;
        this.id = builder.id;
    }

    public final List<RunExport> export() {
        return RunExportListCopier.copyStringToEnum(this.export);
    }

    public final boolean hasExport() {
        return this.export != null && !(this.export instanceof SdkAutoConstructList);
    }

    public final List<String> exportAsStrings() {
        return this.export;
    }

    public final String id() {
        return this.id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExport() ? this.exportAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunRequest)) {
            return false;
        }
        GetRunRequest other = (GetRunRequest)((Object)obj);
        return this.hasExport() == other.hasExport() && Objects.equals(this.exportAsStrings(), other.exportAsStrings()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"GetRunRequest").add("Export", this.hasExport() ? this.exportAsStrings() : null).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "export": {
                return Optional.ofNullable(clazz.cast(this.exportAsStrings()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunRequest, T> g) {
        return obj -> g.apply((GetRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private List<String> export = DefaultSdkAutoConstructList.getInstance();
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunRequest model) {
            super(model);
            this.exportWithStrings(model.export);
            this.id(model.id);
        }

        public final Collection<String> getExport() {
            if (this.export instanceof SdkAutoConstructList) {
                return null;
            }
            return this.export;
        }

        public final void setExport(Collection<String> export) {
            this.export = RunExportListCopier.copy(export);
        }

        @Override
        public final Builder exportWithStrings(Collection<String> export) {
            this.export = RunExportListCopier.copy(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportWithStrings(String ... export) {
            this.exportWithStrings(Arrays.asList(export));
            return this;
        }

        @Override
        public final Builder export(Collection<RunExport> export) {
            this.export = RunExportListCopier.copyEnumToString(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder export(RunExport ... export) {
            this.export(Arrays.asList(export));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRunRequest build() {
            return new GetRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRunRequest> {
        public Builder exportWithStrings(Collection<String> var1);

        public Builder exportWithStrings(String ... var1);

        public Builder export(Collection<RunExport> var1);

        public Builder export(RunExport ... var1);

        public Builder id(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

