/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.TaskListItem;

public class ListRunTasksIterable
implements SdkIterable<ListRunTasksResponse> {
    private final OmicsClient client;
    private final ListRunTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRunTasksIterable(OmicsClient client, ListRunTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRunTasksResponseFetcher();
    }

    public Iterator<ListRunTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TaskListItem> items() {
        Function<ListRunTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRunTasksResponseFetcher
    implements SyncPageFetcher<ListRunTasksResponse> {
        private ListRunTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListRunTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRunTasksResponse nextPage(ListRunTasksResponse previousPage) {
            if (previousPage == null) {
                return ListRunTasksIterable.this.client.listRunTasks(ListRunTasksIterable.this.firstRequest);
            }
            return ListRunTasksIterable.this.client.listRunTasks((ListRunTasksRequest)((Object)ListRunTasksIterable.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

