/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.AnnotationStoreItem;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;

public class ListAnnotationStoresPublisher
implements SdkPublisher<ListAnnotationStoresResponse> {
    private final OmicsAsyncClient client;
    private final ListAnnotationStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnnotationStoresPublisher(OmicsAsyncClient client, ListAnnotationStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnnotationStoresPublisher(OmicsAsyncClient client, ListAnnotationStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnnotationStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnnotationStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnnotationStoreItem> annotationStores() {
        Function<ListAnnotationStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.annotationStores() != null) {
                return response.annotationStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnnotationStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnnotationStoresResponseFetcher
    implements AsyncPageFetcher<ListAnnotationStoresResponse> {
        private ListAnnotationStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListAnnotationStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnnotationStoresResponse> nextPage(ListAnnotationStoresResponse previousPage) {
            if (previousPage == null) {
                return ListAnnotationStoresPublisher.this.client.listAnnotationStores(ListAnnotationStoresPublisher.this.firstRequest);
            }
            return ListAnnotationStoresPublisher.this.client.listAnnotationStores((ListAnnotationStoresRequest)((Object)ListAnnotationStoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

