/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVariantImportJobsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListVariantImportJobsFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListVariantImportJobsFilter.getter(ListVariantImportJobsFilter::statusAsString)).setter(ListVariantImportJobsFilter.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeName").getter(ListVariantImportJobsFilter.getter(ListVariantImportJobsFilter::storeName)).setter(ListVariantImportJobsFilter.setter(Builder::storeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STORE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String storeName;

    private ListVariantImportJobsFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.storeName = builder.storeName;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String storeName() {
        return this.storeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVariantImportJobsFilter)) {
            return false;
        }
        ListVariantImportJobsFilter other = (ListVariantImportJobsFilter)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.storeName(), other.storeName());
    }

    public final String toString() {
        return ToString.builder((String)"ListVariantImportJobsFilter").add("Status", (Object)this.statusAsString()).add("StoreName", (Object)this.storeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "storeName": {
                return Optional.ofNullable(clazz.cast(this.storeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVariantImportJobsFilter, T> g) {
        return obj -> g.apply((ListVariantImportJobsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String storeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVariantImportJobsFilter model) {
            this.status(model.status);
            this.storeName(model.storeName);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStoreName() {
            return this.storeName;
        }

        public final void setStoreName(String storeName) {
            this.storeName = storeName;
        }

        @Override
        public final Builder storeName(String storeName) {
            this.storeName = storeName;
            return this;
        }

        public ListVariantImportJobsFilter build() {
            return new ListVariantImportJobsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListVariantImportJobsFilter> {
        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder storeName(String var1);
    }
}

