/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRunTaskResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetRunTaskResponse> {
    private static final SdkField<Integer> CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpus").getter(GetRunTaskResponse.getter(GetRunTaskResponse::cpus)).setter(GetRunTaskResponse.setter(Builder::cpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetRunTaskResponse.getter(GetRunTaskResponse::creationTime)).setter(GetRunTaskResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStream").getter(GetRunTaskResponse.getter(GetRunTaskResponse::logStream)).setter(GetRunTaskResponse.setter(Builder::logStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStream").build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(GetRunTaskResponse.getter(GetRunTaskResponse::memory)).setter(GetRunTaskResponse.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRunTaskResponse.getter(GetRunTaskResponse::name)).setter(GetRunTaskResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetRunTaskResponse.getter(GetRunTaskResponse::startTime)).setter(GetRunTaskResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetRunTaskResponse.getter(GetRunTaskResponse::statusAsString)).setter(GetRunTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetRunTaskResponse.getter(GetRunTaskResponse::statusMessage)).setter(GetRunTaskResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopTime").getter(GetRunTaskResponse.getter(GetRunTaskResponse::stopTime)).setter(GetRunTaskResponse.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(GetRunTaskResponse.getter(GetRunTaskResponse::taskId)).setter(GetRunTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPUS_FIELD, CREATION_TIME_FIELD, LOG_STREAM_FIELD, MEMORY_FIELD, NAME_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STOP_TIME_FIELD, TASK_ID_FIELD));
    private final Integer cpus;
    private final Instant creationTime;
    private final String logStream;
    private final Integer memory;
    private final String name;
    private final Instant startTime;
    private final String status;
    private final String statusMessage;
    private final Instant stopTime;
    private final String taskId;

    private GetRunTaskResponse(BuilderImpl builder) {
        super(builder);
        this.cpus = builder.cpus;
        this.creationTime = builder.creationTime;
        this.logStream = builder.logStream;
        this.memory = builder.memory;
        this.name = builder.name;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.stopTime = builder.stopTime;
        this.taskId = builder.taskId;
    }

    public final Integer cpus() {
        return this.cpus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String logStream() {
        return this.logStream;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final String name() {
        return this.name;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final TaskStatus status() {
        return TaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public final String taskId() {
        return this.taskId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunTaskResponse)) {
            return false;
        }
        GetRunTaskResponse other = (GetRunTaskResponse)((Object)obj);
        return Objects.equals(this.cpus(), other.cpus()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.logStream(), other.logStream()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.stopTime(), other.stopTime()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"GetRunTaskResponse").add("Cpus", (Object)this.cpus()).add("CreationTime", (Object)this.creationTime()).add("LogStream", (Object)this.logStream()).add("Memory", (Object)this.memory()).add("Name", (Object)this.name()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StopTime", (Object)this.stopTime()).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpus": {
                return Optional.ofNullable(clazz.cast(this.cpus()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "logStream": {
                return Optional.ofNullable(clazz.cast(this.logStream()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "stopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunTaskResponse, T> g) {
        return obj -> g.apply((GetRunTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private Integer cpus;
        private Instant creationTime;
        private String logStream;
        private Integer memory;
        private String name;
        private Instant startTime;
        private String status;
        private String statusMessage;
        private Instant stopTime;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunTaskResponse model) {
            super(model);
            this.cpus(model.cpus);
            this.creationTime(model.creationTime);
            this.logStream(model.logStream);
            this.memory(model.memory);
            this.name(model.name);
            this.startTime(model.startTime);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.stopTime(model.stopTime);
            this.taskId(model.taskId);
        }

        public final Integer getCpus() {
            return this.cpus;
        }

        public final void setCpus(Integer cpus) {
            this.cpus = cpus;
        }

        @Override
        public final Builder cpus(Integer cpus) {
            this.cpus = cpus;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLogStream() {
            return this.logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public GetRunTaskResponse build() {
            return new GetRunTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRunTaskResponse> {
        public Builder cpus(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder logStream(String var1);

        public Builder memory(Integer var1);

        public Builder name(String var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(TaskStatus var1);

        public Builder statusMessage(String var1);

        public Builder stopTime(Instant var1);

        public Builder taskId(String var1);
    }
}

