/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRunGroupResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetRunGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetRunGroupResponse.getter(GetRunGroupResponse::arn)).setter(GetRunGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetRunGroupResponse.getter(GetRunGroupResponse::creationTime)).setter(GetRunGroupResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetRunGroupResponse.getter(GetRunGroupResponse::id)).setter(GetRunGroupResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Integer> MAX_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCpus").getter(GetRunGroupResponse.getter(GetRunGroupResponse::maxCpus)).setter(GetRunGroupResponse.setter(Builder::maxCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpus").build()}).build();
    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDuration").getter(GetRunGroupResponse.getter(GetRunGroupResponse::maxDuration)).setter(GetRunGroupResponse.setter(Builder::maxDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDuration").build()}).build();
    private static final SdkField<Integer> MAX_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxRuns").getter(GetRunGroupResponse.getter(GetRunGroupResponse::maxRuns)).setter(GetRunGroupResponse.setter(Builder::maxRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRuns").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRunGroupResponse.getter(GetRunGroupResponse::name)).setter(GetRunGroupResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetRunGroupResponse.getter(GetRunGroupResponse::tags)).setter(GetRunGroupResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, ID_FIELD, MAX_CPUS_FIELD, MAX_DURATION_FIELD, MAX_RUNS_FIELD, NAME_FIELD, TAGS_FIELD));
    private final String arn;
    private final Instant creationTime;
    private final String id;
    private final Integer maxCpus;
    private final Integer maxDuration;
    private final Integer maxRuns;
    private final String name;
    private final Map<String, String> tags;

    private GetRunGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.maxCpus = builder.maxCpus;
        this.maxDuration = builder.maxDuration;
        this.maxRuns = builder.maxRuns;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final Integer maxCpus() {
        return this.maxCpus;
    }

    public final Integer maxDuration() {
        return this.maxDuration;
    }

    public final Integer maxRuns() {
        return this.maxRuns;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRuns());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunGroupResponse)) {
            return false;
        }
        GetRunGroupResponse other = (GetRunGroupResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.maxCpus(), other.maxCpus()) && Objects.equals(this.maxDuration(), other.maxDuration()) && Objects.equals(this.maxRuns(), other.maxRuns()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetRunGroupResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("Id", (Object)this.id()).add("MaxCpus", (Object)this.maxCpus()).add("MaxDuration", (Object)this.maxDuration()).add("MaxRuns", (Object)this.maxRuns()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "maxCpus": {
                return Optional.ofNullable(clazz.cast(this.maxCpus()));
            }
            case "maxDuration": {
                return Optional.ofNullable(clazz.cast(this.maxDuration()));
            }
            case "maxRuns": {
                return Optional.ofNullable(clazz.cast(this.maxRuns()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunGroupResponse, T> g) {
        return obj -> g.apply((GetRunGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String id;
        private Integer maxCpus;
        private Integer maxDuration;
        private Integer maxRuns;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunGroupResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.id(model.id);
            this.maxCpus(model.maxCpus);
            this.maxDuration(model.maxDuration);
            this.maxRuns(model.maxRuns);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getMaxCpus() {
            return this.maxCpus;
        }

        public final void setMaxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
        }

        @Override
        public final Builder maxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        public final Integer getMaxDuration() {
            return this.maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Integer getMaxRuns() {
            return this.maxRuns;
        }

        public final void setMaxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
        }

        @Override
        public final Builder maxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetRunGroupResponse build() {
            return new GetRunGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRunGroupResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder id(String var1);

        public Builder maxCpus(Integer var1);

        public Builder maxDuration(Integer var1);

        public Builder maxRuns(Integer var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

