/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterListCopier;
import software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCloudAutonomousVmClustersResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListCloudAutonomousVmClustersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCloudAutonomousVmClustersResponse.getter(ListCloudAutonomousVmClustersResponse::nextToken)).setter(ListCloudAutonomousVmClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CloudAutonomousVmClusterSummary>> CLOUD_AUTONOMOUS_VM_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cloudAutonomousVmClusters").getter(ListCloudAutonomousVmClustersResponse.getter(ListCloudAutonomousVmClustersResponse::cloudAutonomousVmClusters)).setter(ListCloudAutonomousVmClustersResponse.setter(Builder::cloudAutonomousVmClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudAutonomousVmClusterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CLOUD_AUTONOMOUS_VM_CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCloudAutonomousVmClustersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CloudAutonomousVmClusterSummary> cloudAutonomousVmClusters;

    private ListCloudAutonomousVmClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cloudAutonomousVmClusters = builder.cloudAutonomousVmClusters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCloudAutonomousVmClusters() {
        return this.cloudAutonomousVmClusters != null && !(this.cloudAutonomousVmClusters instanceof SdkAutoConstructList);
    }

    public final List<CloudAutonomousVmClusterSummary> cloudAutonomousVmClusters() {
        return this.cloudAutonomousVmClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudAutonomousVmClusters() ? this.cloudAutonomousVmClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudAutonomousVmClustersResponse)) {
            return false;
        }
        ListCloudAutonomousVmClustersResponse other = (ListCloudAutonomousVmClustersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCloudAutonomousVmClusters() == other.hasCloudAutonomousVmClusters() && Objects.equals(this.cloudAutonomousVmClusters(), other.cloudAutonomousVmClusters());
    }

    public final String toString() {
        return ToString.builder((String)"ListCloudAutonomousVmClustersResponse").add("NextToken", (Object)this.nextToken()).add("CloudAutonomousVmClusters", this.hasCloudAutonomousVmClusters() ? this.cloudAutonomousVmClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "cloudAutonomousVmClusters": {
                return Optional.ofNullable(clazz.cast(this.cloudAutonomousVmClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("cloudAutonomousVmClusters", CLOUD_AUTONOMOUS_VM_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCloudAutonomousVmClustersResponse, T> g) {
        return obj -> g.apply((ListCloudAutonomousVmClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CloudAutonomousVmClusterSummary> cloudAutonomousVmClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudAutonomousVmClustersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.cloudAutonomousVmClusters(model.cloudAutonomousVmClusters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CloudAutonomousVmClusterSummary.Builder> getCloudAutonomousVmClusters() {
            List<CloudAutonomousVmClusterSummary.Builder> result = CloudAutonomousVmClusterListCopier.copyToBuilder(this.cloudAutonomousVmClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudAutonomousVmClusters(Collection<CloudAutonomousVmClusterSummary.BuilderImpl> cloudAutonomousVmClusters) {
            this.cloudAutonomousVmClusters = CloudAutonomousVmClusterListCopier.copyFromBuilder(cloudAutonomousVmClusters);
        }

        @Override
        public final Builder cloudAutonomousVmClusters(Collection<CloudAutonomousVmClusterSummary> cloudAutonomousVmClusters) {
            this.cloudAutonomousVmClusters = CloudAutonomousVmClusterListCopier.copy(cloudAutonomousVmClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudAutonomousVmClusters(CloudAutonomousVmClusterSummary ... cloudAutonomousVmClusters) {
            this.cloudAutonomousVmClusters(Arrays.asList(cloudAutonomousVmClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudAutonomousVmClusters(Consumer<CloudAutonomousVmClusterSummary.Builder> ... cloudAutonomousVmClusters) {
            this.cloudAutonomousVmClusters(Stream.of(cloudAutonomousVmClusters).map(c -> (CloudAutonomousVmClusterSummary)((CloudAutonomousVmClusterSummary.Builder)CloudAutonomousVmClusterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCloudAutonomousVmClustersResponse build() {
            return new ListCloudAutonomousVmClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCloudAutonomousVmClustersResponse> {
        public Builder nextToken(String var1);

        public Builder cloudAutonomousVmClusters(Collection<CloudAutonomousVmClusterSummary> var1);

        public Builder cloudAutonomousVmClusters(CloudAutonomousVmClusterSummary ... var1);

        public Builder cloudAutonomousVmClusters(Consumer<CloudAutonomousVmClusterSummary.Builder> ... var1);
    }
}

