/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DbNodeResourceStatus {
    AVAILABLE("AVAILABLE"),
    FAILED("FAILED"),
    PROVISIONING("PROVISIONING"),
    TERMINATED("TERMINATED"),
    TERMINATING("TERMINATING"),
    UPDATING("UPDATING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    STARTING("STARTING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DbNodeResourceStatus> VALUE_MAP;
    private final String value;

    private DbNodeResourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DbNodeResourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DbNodeResourceStatus> knownValues() {
        EnumSet<DbNodeResourceStatus> knownValues = EnumSet.allOf(DbNodeResourceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DbNodeResourceStatus.class, DbNodeResourceStatus::toString);
    }
}

