/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.IamRoleStatus;
import software.amazon.awssdk.services.odb.model.SupportedAwsIntegration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamRole
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IamRole> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleArn").getter(IamRole.getter(IamRole::iamRoleArn)).setter(IamRole.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(IamRole.getter(IamRole::statusAsString)).setter(IamRole.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(IamRole.getter(IamRole::statusReason)).setter(IamRole.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> AWS_INTEGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsIntegration").getter(IamRole.getter(IamRole::awsIntegrationAsString)).setter(IamRole.setter(Builder::awsIntegration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIntegration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, AWS_INTEGRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IamRole.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String iamRoleArn;
    private final String status;
    private final String statusReason;
    private final String awsIntegration;

    private IamRole(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.awsIntegration = builder.awsIntegration;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final IamRoleStatus status() {
        return IamRoleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final SupportedAwsIntegration awsIntegration() {
        return SupportedAwsIntegration.fromValue(this.awsIntegration);
    }

    public final String awsIntegrationAsString() {
        return this.awsIntegration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIntegrationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamRole)) {
            return false;
        }
        IamRole other = (IamRole)obj;
        return Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.awsIntegrationAsString(), other.awsIntegrationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IamRole").add("IamRoleArn", (Object)this.iamRoleArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("AwsIntegration", (Object)this.awsIntegrationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "awsIntegration": {
                return Optional.ofNullable(clazz.cast(this.awsIntegrationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("awsIntegration", AWS_INTEGRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamRole, T> g) {
        return obj -> g.apply((IamRole)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String iamRoleArn;
        private String status;
        private String statusReason;
        private String awsIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(IamRole model) {
            this.iamRoleArn(model.iamRoleArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.awsIntegration(model.awsIntegration);
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IamRoleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAwsIntegration() {
            return this.awsIntegration;
        }

        public final void setAwsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
        }

        @Override
        public final Builder awsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
            return this;
        }

        @Override
        public final Builder awsIntegration(SupportedAwsIntegration awsIntegration) {
            this.awsIntegration(awsIntegration == null ? null : awsIntegration.toString());
            return this;
        }

        public IamRole build() {
            return new IamRole(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IamRole> {
        public Builder iamRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(IamRoleStatus var1);

        public Builder statusReason(String var1);

        public Builder awsIntegration(String var1);

        public Builder awsIntegration(SupportedAwsIntegration var1);
    }
}

