/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.ComputeModel;
import software.amazon.awssdk.services.odb.model.CustomerContact;
import software.amazon.awssdk.services.odb.model.CustomerContactsCopier;
import software.amazon.awssdk.services.odb.model.MaintenanceWindow;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudExadataInfrastructureSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudExadataInfrastructureSummary> {
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudExadataInfrastructureId").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::cloudExadataInfrastructureId)).setter(CloudExadataInfrastructureSummary.setter(Builder::cloudExadataInfrastructureId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::displayName)).setter(CloudExadataInfrastructureSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::statusAsString)).setter(CloudExadataInfrastructureSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::statusReason)).setter(CloudExadataInfrastructureSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudExadataInfrastructureArn").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::cloudExadataInfrastructureArn)).setter(CloudExadataInfrastructureSummary.setter(Builder::cloudExadataInfrastructureArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureArn").build()}).build();
    private static final SdkField<Integer> ACTIVATED_STORAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("activatedStorageCount").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::activatedStorageCount)).setter(CloudExadataInfrastructureSummary.setter(Builder::activatedStorageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activatedStorageCount").build()}).build();
    private static final SdkField<Integer> ADDITIONAL_STORAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("additionalStorageCount").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::additionalStorageCount)).setter(CloudExadataInfrastructureSummary.setter(Builder::additionalStorageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalStorageCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableStorageSizeInGBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::availableStorageSizeInGBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::availableStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableStorageSizeInGBs").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::availabilityZone)).setter(CloudExadataInfrastructureSummary.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::availabilityZoneId)).setter(CloudExadataInfrastructureSummary.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Integer> COMPUTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("computeCount").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::computeCount)).setter(CloudExadataInfrastructureSummary.setter(Builder::computeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeCount").build()}).build();
    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCount").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::cpuCount)).setter(CloudExadataInfrastructureSummary.setter(Builder::cpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()}).build();
    private static final SdkField<List<CustomerContact>> CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customerContactsToSendToOCI").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::customerContactsToSendToOCI)).setter(CloudExadataInfrastructureSummary.setter(Builder::customerContactsToSendToOCI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerContactsToSendToOCI").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomerContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("dataStorageSizeInTBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::dataStorageSizeInTBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::dataStorageSizeInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build()}).build();
    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::dbNodeStorageSizeInGBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::dbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<String> DB_SERVER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbServerVersion").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::dbServerVersion)).setter(CloudExadataInfrastructureSummary.setter(Builder::dbServerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerVersion").build()}).build();
    private static final SdkField<String> LAST_MAINTENANCE_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastMaintenanceRunId").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::lastMaintenanceRunId)).setter(CloudExadataInfrastructureSummary.setter(Builder::lastMaintenanceRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastMaintenanceRunId").build()}).build();
    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maintenanceWindow").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::maintenanceWindow)).setter(CloudExadataInfrastructureSummary.setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()}).build();
    private static final SdkField<Integer> MAX_CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCpuCount").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::maxCpuCount)).setter(CloudExadataInfrastructureSummary.setter(Builder::maxCpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpuCount").build()}).build();
    private static final SdkField<Double> MAX_DATA_STORAGE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("maxDataStorageInTBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::maxDataStorageInTBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::maxDataStorageInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDataStorageInTBs").build()}).build();
    private static final SdkField<Integer> MAX_DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDbNodeStorageSizeInGBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::maxDbNodeStorageSizeInGBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::maxDbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<Integer> MAX_MEMORY_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxMemoryInGBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::maxMemoryInGBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::maxMemoryInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMemoryInGBs").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInGBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::memorySizeInGBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::memorySizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()}).build();
    private static final SdkField<String> MONTHLY_DB_SERVER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monthlyDbServerVersion").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::monthlyDbServerVersion)).setter(CloudExadataInfrastructureSummary.setter(Builder::monthlyDbServerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyDbServerVersion").build()}).build();
    private static final SdkField<String> MONTHLY_STORAGE_SERVER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monthlyStorageServerVersion").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::monthlyStorageServerVersion)).setter(CloudExadataInfrastructureSummary.setter(Builder::monthlyStorageServerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyStorageServerVersion").build()}).build();
    private static final SdkField<String> NEXT_MAINTENANCE_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextMaintenanceRunId").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::nextMaintenanceRunId)).setter(CloudExadataInfrastructureSummary.setter(Builder::nextMaintenanceRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMaintenanceRunId").build()}).build();
    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociResourceAnchorName").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::ociResourceAnchorName)).setter(CloudExadataInfrastructureSummary.setter(Builder::ociResourceAnchorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build()}).build();
    private static final SdkField<String> OCI_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociUrl").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::ociUrl)).setter(CloudExadataInfrastructureSummary.setter(Builder::ociUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociUrl").build()}).build();
    private static final SdkField<String> OCID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocid").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::ocid)).setter(CloudExadataInfrastructureSummary.setter(Builder::ocid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::shape)).setter(CloudExadataInfrastructureSummary.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<Integer> STORAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCount").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::storageCount)).setter(CloudExadataInfrastructureSummary.setter(Builder::storageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCount").build()}).build();
    private static final SdkField<String> STORAGE_SERVER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageServerVersion").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::storageServerVersion)).setter(CloudExadataInfrastructureSummary.setter(Builder::storageServerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageServerVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::createdAt)).setter(CloudExadataInfrastructureSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> TOTAL_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalStorageSizeInGBs").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::totalStorageSizeInGBs)).setter(CloudExadataInfrastructureSummary.setter(Builder::totalStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStorageSizeInGBs").build()}).build();
    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("percentProgress").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::percentProgress)).setter(CloudExadataInfrastructureSummary.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()}).build();
    private static final SdkField<String> DATABASE_SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseServerType").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::databaseServerType)).setter(CloudExadataInfrastructureSummary.setter(Builder::databaseServerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseServerType").build()}).build();
    private static final SdkField<String> STORAGE_SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageServerType").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::storageServerType)).setter(CloudExadataInfrastructureSummary.setter(Builder::storageServerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageServerType").build()}).build();
    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeModel").getter(CloudExadataInfrastructureSummary.getter(CloudExadataInfrastructureSummary::computeModelAsString)).setter(CloudExadataInfrastructureSummary.setter(Builder::computeModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CLOUD_EXADATA_INFRASTRUCTURE_ARN_FIELD, ACTIVATED_STORAGE_COUNT_FIELD, ADDITIONAL_STORAGE_COUNT_FIELD, AVAILABLE_STORAGE_SIZE_IN_G_BS_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, COMPUTE_COUNT_FIELD, CPU_COUNT_FIELD, CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD, DATA_STORAGE_SIZE_IN_T_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVER_VERSION_FIELD, LAST_MAINTENANCE_RUN_ID_FIELD, MAINTENANCE_WINDOW_FIELD, MAX_CPU_COUNT_FIELD, MAX_DATA_STORAGE_IN_T_BS_FIELD, MAX_DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, MAX_MEMORY_IN_G_BS_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, MONTHLY_DB_SERVER_VERSION_FIELD, MONTHLY_STORAGE_SERVER_VERSION_FIELD, NEXT_MAINTENANCE_RUN_ID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, OCI_URL_FIELD, OCID_FIELD, SHAPE_FIELD, STORAGE_COUNT_FIELD, STORAGE_SERVER_VERSION_FIELD, CREATED_AT_FIELD, TOTAL_STORAGE_SIZE_IN_G_BS_FIELD, PERCENT_PROGRESS_FIELD, DATABASE_SERVER_TYPE_FIELD, STORAGE_SERVER_TYPE_FIELD, COMPUTE_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudExadataInfrastructureSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cloudExadataInfrastructureId;
    private final String displayName;
    private final String status;
    private final String statusReason;
    private final String cloudExadataInfrastructureArn;
    private final Integer activatedStorageCount;
    private final Integer additionalStorageCount;
    private final Integer availableStorageSizeInGBs;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final Integer computeCount;
    private final Integer cpuCount;
    private final List<CustomerContact> customerContactsToSendToOCI;
    private final Double dataStorageSizeInTBs;
    private final Integer dbNodeStorageSizeInGBs;
    private final String dbServerVersion;
    private final String lastMaintenanceRunId;
    private final MaintenanceWindow maintenanceWindow;
    private final Integer maxCpuCount;
    private final Double maxDataStorageInTBs;
    private final Integer maxDbNodeStorageSizeInGBs;
    private final Integer maxMemoryInGBs;
    private final Integer memorySizeInGBs;
    private final String monthlyDbServerVersion;
    private final String monthlyStorageServerVersion;
    private final String nextMaintenanceRunId;
    private final String ociResourceAnchorName;
    private final String ociUrl;
    private final String ocid;
    private final String shape;
    private final Integer storageCount;
    private final String storageServerVersion;
    private final Instant createdAt;
    private final Integer totalStorageSizeInGBs;
    private final Float percentProgress;
    private final String databaseServerType;
    private final String storageServerType;
    private final String computeModel;

    private CloudExadataInfrastructureSummary(BuilderImpl builder) {
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cloudExadataInfrastructureArn = builder.cloudExadataInfrastructureArn;
        this.activatedStorageCount = builder.activatedStorageCount;
        this.additionalStorageCount = builder.additionalStorageCount;
        this.availableStorageSizeInGBs = builder.availableStorageSizeInGBs;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.computeCount = builder.computeCount;
        this.cpuCount = builder.cpuCount;
        this.customerContactsToSendToOCI = builder.customerContactsToSendToOCI;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServerVersion = builder.dbServerVersion;
        this.lastMaintenanceRunId = builder.lastMaintenanceRunId;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.maxCpuCount = builder.maxCpuCount;
        this.maxDataStorageInTBs = builder.maxDataStorageInTBs;
        this.maxDbNodeStorageSizeInGBs = builder.maxDbNodeStorageSizeInGBs;
        this.maxMemoryInGBs = builder.maxMemoryInGBs;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.monthlyDbServerVersion = builder.monthlyDbServerVersion;
        this.monthlyStorageServerVersion = builder.monthlyStorageServerVersion;
        this.nextMaintenanceRunId = builder.nextMaintenanceRunId;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.ociUrl = builder.ociUrl;
        this.ocid = builder.ocid;
        this.shape = builder.shape;
        this.storageCount = builder.storageCount;
        this.storageServerVersion = builder.storageServerVersion;
        this.createdAt = builder.createdAt;
        this.totalStorageSizeInGBs = builder.totalStorageSizeInGBs;
        this.percentProgress = builder.percentProgress;
        this.databaseServerType = builder.databaseServerType;
        this.storageServerType = builder.storageServerType;
        this.computeModel = builder.computeModel;
    }

    public final String cloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String cloudExadataInfrastructureArn() {
        return this.cloudExadataInfrastructureArn;
    }

    public final Integer activatedStorageCount() {
        return this.activatedStorageCount;
    }

    public final Integer additionalStorageCount() {
        return this.additionalStorageCount;
    }

    public final Integer availableStorageSizeInGBs() {
        return this.availableStorageSizeInGBs;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Integer computeCount() {
        return this.computeCount;
    }

    public final Integer cpuCount() {
        return this.cpuCount;
    }

    public final boolean hasCustomerContactsToSendToOCI() {
        return this.customerContactsToSendToOCI != null && !(this.customerContactsToSendToOCI instanceof SdkAutoConstructList);
    }

    public final List<CustomerContact> customerContactsToSendToOCI() {
        return this.customerContactsToSendToOCI;
    }

    public final Double dataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public final Integer dbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public final String dbServerVersion() {
        return this.dbServerVersion;
    }

    public final String lastMaintenanceRunId() {
        return this.lastMaintenanceRunId;
    }

    public final MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final Integer maxCpuCount() {
        return this.maxCpuCount;
    }

    public final Double maxDataStorageInTBs() {
        return this.maxDataStorageInTBs;
    }

    public final Integer maxDbNodeStorageSizeInGBs() {
        return this.maxDbNodeStorageSizeInGBs;
    }

    public final Integer maxMemoryInGBs() {
        return this.maxMemoryInGBs;
    }

    public final Integer memorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public final String monthlyDbServerVersion() {
        return this.monthlyDbServerVersion;
    }

    public final String monthlyStorageServerVersion() {
        return this.monthlyStorageServerVersion;
    }

    public final String nextMaintenanceRunId() {
        return this.nextMaintenanceRunId;
    }

    public final String ociResourceAnchorName() {
        return this.ociResourceAnchorName;
    }

    public final String ociUrl() {
        return this.ociUrl;
    }

    public final String ocid() {
        return this.ocid;
    }

    public final String shape() {
        return this.shape;
    }

    public final Integer storageCount() {
        return this.storageCount;
    }

    public final String storageServerVersion() {
        return this.storageServerVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Integer totalStorageSizeInGBs() {
        return this.totalStorageSizeInGBs;
    }

    public final Float percentProgress() {
        return this.percentProgress;
    }

    public final String databaseServerType() {
        return this.databaseServerType;
    }

    public final String storageServerType() {
        return this.storageServerType;
    }

    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(this.computeModel);
    }

    public final String computeModelAsString() {
        return this.computeModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudExadataInfrastructureArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.activatedStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerContactsToSendToOCI() ? this.customerContactsToSendToOCI() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastMaintenanceRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDataStorageInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMemoryInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyDbServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyStorageServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMaintenanceRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocid());
        hashCode = 31 * hashCode + Objects.hashCode(this.shape());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseServerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageServerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeModelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudExadataInfrastructureSummary)) {
            return false;
        }
        CloudExadataInfrastructureSummary other = (CloudExadataInfrastructureSummary)obj;
        return Objects.equals(this.cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.cloudExadataInfrastructureArn(), other.cloudExadataInfrastructureArn()) && Objects.equals(this.activatedStorageCount(), other.activatedStorageCount()) && Objects.equals(this.additionalStorageCount(), other.additionalStorageCount()) && Objects.equals(this.availableStorageSizeInGBs(), other.availableStorageSizeInGBs()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.computeCount(), other.computeCount()) && Objects.equals(this.cpuCount(), other.cpuCount()) && this.hasCustomerContactsToSendToOCI() == other.hasCustomerContactsToSendToOCI() && Objects.equals(this.customerContactsToSendToOCI(), other.customerContactsToSendToOCI()) && Objects.equals(this.dataStorageSizeInTBs(), other.dataStorageSizeInTBs()) && Objects.equals(this.dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs()) && Objects.equals(this.dbServerVersion(), other.dbServerVersion()) && Objects.equals(this.lastMaintenanceRunId(), other.lastMaintenanceRunId()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.maxCpuCount(), other.maxCpuCount()) && Objects.equals(this.maxDataStorageInTBs(), other.maxDataStorageInTBs()) && Objects.equals(this.maxDbNodeStorageSizeInGBs(), other.maxDbNodeStorageSizeInGBs()) && Objects.equals(this.maxMemoryInGBs(), other.maxMemoryInGBs()) && Objects.equals(this.memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(this.monthlyDbServerVersion(), other.monthlyDbServerVersion()) && Objects.equals(this.monthlyStorageServerVersion(), other.monthlyStorageServerVersion()) && Objects.equals(this.nextMaintenanceRunId(), other.nextMaintenanceRunId()) && Objects.equals(this.ociResourceAnchorName(), other.ociResourceAnchorName()) && Objects.equals(this.ociUrl(), other.ociUrl()) && Objects.equals(this.ocid(), other.ocid()) && Objects.equals(this.shape(), other.shape()) && Objects.equals(this.storageCount(), other.storageCount()) && Objects.equals(this.storageServerVersion(), other.storageServerVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.totalStorageSizeInGBs(), other.totalStorageSizeInGBs()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.databaseServerType(), other.databaseServerType()) && Objects.equals(this.storageServerType(), other.storageServerType()) && Objects.equals(this.computeModelAsString(), other.computeModelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CloudExadataInfrastructureSummary").add("CloudExadataInfrastructureId", (Object)this.cloudExadataInfrastructureId()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CloudExadataInfrastructureArn", (Object)this.cloudExadataInfrastructureArn()).add("ActivatedStorageCount", (Object)this.activatedStorageCount()).add("AdditionalStorageCount", (Object)this.additionalStorageCount()).add("AvailableStorageSizeInGBs", (Object)this.availableStorageSizeInGBs()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("ComputeCount", (Object)this.computeCount()).add("CpuCount", (Object)this.cpuCount()).add("CustomerContactsToSendToOCI", this.hasCustomerContactsToSendToOCI() ? this.customerContactsToSendToOCI() : null).add("DataStorageSizeInTBs", (Object)this.dataStorageSizeInTBs()).add("DbNodeStorageSizeInGBs", (Object)this.dbNodeStorageSizeInGBs()).add("DbServerVersion", (Object)this.dbServerVersion()).add("LastMaintenanceRunId", (Object)this.lastMaintenanceRunId()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("MaxCpuCount", (Object)this.maxCpuCount()).add("MaxDataStorageInTBs", (Object)this.maxDataStorageInTBs()).add("MaxDbNodeStorageSizeInGBs", (Object)this.maxDbNodeStorageSizeInGBs()).add("MaxMemoryInGBs", (Object)this.maxMemoryInGBs()).add("MemorySizeInGBs", (Object)this.memorySizeInGBs()).add("MonthlyDbServerVersion", (Object)this.monthlyDbServerVersion()).add("MonthlyStorageServerVersion", (Object)this.monthlyStorageServerVersion()).add("NextMaintenanceRunId", (Object)this.nextMaintenanceRunId()).add("OciResourceAnchorName", (Object)this.ociResourceAnchorName()).add("OciUrl", (Object)this.ociUrl()).add("Ocid", (Object)this.ocid()).add("Shape", (Object)this.shape()).add("StorageCount", (Object)this.storageCount()).add("StorageServerVersion", (Object)this.storageServerVersion()).add("CreatedAt", (Object)this.createdAt()).add("TotalStorageSizeInGBs", (Object)this.totalStorageSizeInGBs()).add("PercentProgress", (Object)this.percentProgress()).add("DatabaseServerType", (Object)this.databaseServerType()).add("StorageServerType", (Object)this.storageServerType()).add("ComputeModel", (Object)this.computeModelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudExadataInfrastructureId": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructureId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "cloudExadataInfrastructureArn": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructureArn()));
            }
            case "activatedStorageCount": {
                return Optional.ofNullable(clazz.cast(this.activatedStorageCount()));
            }
            case "additionalStorageCount": {
                return Optional.ofNullable(clazz.cast(this.additionalStorageCount()));
            }
            case "availableStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.availableStorageSizeInGBs()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "computeCount": {
                return Optional.ofNullable(clazz.cast(this.computeCount()));
            }
            case "cpuCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCount()));
            }
            case "customerContactsToSendToOCI": {
                return Optional.ofNullable(clazz.cast(this.customerContactsToSendToOCI()));
            }
            case "dataStorageSizeInTBs": {
                return Optional.ofNullable(clazz.cast(this.dataStorageSizeInTBs()));
            }
            case "dbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dbNodeStorageSizeInGBs()));
            }
            case "dbServerVersion": {
                return Optional.ofNullable(clazz.cast(this.dbServerVersion()));
            }
            case "lastMaintenanceRunId": {
                return Optional.ofNullable(clazz.cast(this.lastMaintenanceRunId()));
            }
            case "maintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "maxCpuCount": {
                return Optional.ofNullable(clazz.cast(this.maxCpuCount()));
            }
            case "maxDataStorageInTBs": {
                return Optional.ofNullable(clazz.cast(this.maxDataStorageInTBs()));
            }
            case "maxDbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.maxDbNodeStorageSizeInGBs()));
            }
            case "maxMemoryInGBs": {
                return Optional.ofNullable(clazz.cast(this.maxMemoryInGBs()));
            }
            case "memorySizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInGBs()));
            }
            case "monthlyDbServerVersion": {
                return Optional.ofNullable(clazz.cast(this.monthlyDbServerVersion()));
            }
            case "monthlyStorageServerVersion": {
                return Optional.ofNullable(clazz.cast(this.monthlyStorageServerVersion()));
            }
            case "nextMaintenanceRunId": {
                return Optional.ofNullable(clazz.cast(this.nextMaintenanceRunId()));
            }
            case "ociResourceAnchorName": {
                return Optional.ofNullable(clazz.cast(this.ociResourceAnchorName()));
            }
            case "ociUrl": {
                return Optional.ofNullable(clazz.cast(this.ociUrl()));
            }
            case "ocid": {
                return Optional.ofNullable(clazz.cast(this.ocid()));
            }
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shape()));
            }
            case "storageCount": {
                return Optional.ofNullable(clazz.cast(this.storageCount()));
            }
            case "storageServerVersion": {
                return Optional.ofNullable(clazz.cast(this.storageServerVersion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "totalStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.totalStorageSizeInGBs()));
            }
            case "percentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "databaseServerType": {
                return Optional.ofNullable(clazz.cast(this.databaseServerType()));
            }
            case "storageServerType": {
                return Optional.ofNullable(clazz.cast(this.storageServerType()));
            }
            case "computeModel": {
                return Optional.ofNullable(clazz.cast(this.computeModelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cloudExadataInfrastructureArn", CLOUD_EXADATA_INFRASTRUCTURE_ARN_FIELD);
        map.put("activatedStorageCount", ACTIVATED_STORAGE_COUNT_FIELD);
        map.put("additionalStorageCount", ADDITIONAL_STORAGE_COUNT_FIELD);
        map.put("availableStorageSizeInGBs", AVAILABLE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("computeCount", COMPUTE_COUNT_FIELD);
        map.put("cpuCount", CPU_COUNT_FIELD);
        map.put("customerContactsToSendToOCI", CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServerVersion", DB_SERVER_VERSION_FIELD);
        map.put("lastMaintenanceRunId", LAST_MAINTENANCE_RUN_ID_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("maxCpuCount", MAX_CPU_COUNT_FIELD);
        map.put("maxDataStorageInTBs", MAX_DATA_STORAGE_IN_T_BS_FIELD);
        map.put("maxDbNodeStorageSizeInGBs", MAX_DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("maxMemoryInGBs", MAX_MEMORY_IN_G_BS_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("monthlyDbServerVersion", MONTHLY_DB_SERVER_VERSION_FIELD);
        map.put("monthlyStorageServerVersion", MONTHLY_STORAGE_SERVER_VERSION_FIELD);
        map.put("nextMaintenanceRunId", NEXT_MAINTENANCE_RUN_ID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("ociUrl", OCI_URL_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("storageCount", STORAGE_COUNT_FIELD);
        map.put("storageServerVersion", STORAGE_SERVER_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("totalStorageSizeInGBs", TOTAL_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("databaseServerType", DATABASE_SERVER_TYPE_FIELD);
        map.put("storageServerType", STORAGE_SERVER_TYPE_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudExadataInfrastructureSummary, T> g) {
        return obj -> g.apply((CloudExadataInfrastructureSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudExadataInfrastructureId;
        private String displayName;
        private String status;
        private String statusReason;
        private String cloudExadataInfrastructureArn;
        private Integer activatedStorageCount;
        private Integer additionalStorageCount;
        private Integer availableStorageSizeInGBs;
        private String availabilityZone;
        private String availabilityZoneId;
        private Integer computeCount;
        private Integer cpuCount;
        private List<CustomerContact> customerContactsToSendToOCI = DefaultSdkAutoConstructList.getInstance();
        private Double dataStorageSizeInTBs;
        private Integer dbNodeStorageSizeInGBs;
        private String dbServerVersion;
        private String lastMaintenanceRunId;
        private MaintenanceWindow maintenanceWindow;
        private Integer maxCpuCount;
        private Double maxDataStorageInTBs;
        private Integer maxDbNodeStorageSizeInGBs;
        private Integer maxMemoryInGBs;
        private Integer memorySizeInGBs;
        private String monthlyDbServerVersion;
        private String monthlyStorageServerVersion;
        private String nextMaintenanceRunId;
        private String ociResourceAnchorName;
        private String ociUrl;
        private String ocid;
        private String shape;
        private Integer storageCount;
        private String storageServerVersion;
        private Instant createdAt;
        private Integer totalStorageSizeInGBs;
        private Float percentProgress;
        private String databaseServerType;
        private String storageServerType;
        private String computeModel;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudExadataInfrastructureSummary model) {
            this.cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.cloudExadataInfrastructureArn(model.cloudExadataInfrastructureArn);
            this.activatedStorageCount(model.activatedStorageCount);
            this.additionalStorageCount(model.additionalStorageCount);
            this.availableStorageSizeInGBs(model.availableStorageSizeInGBs);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.computeCount(model.computeCount);
            this.cpuCount(model.cpuCount);
            this.customerContactsToSendToOCI(model.customerContactsToSendToOCI);
            this.dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            this.dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            this.dbServerVersion(model.dbServerVersion);
            this.lastMaintenanceRunId(model.lastMaintenanceRunId);
            this.maintenanceWindow(model.maintenanceWindow);
            this.maxCpuCount(model.maxCpuCount);
            this.maxDataStorageInTBs(model.maxDataStorageInTBs);
            this.maxDbNodeStorageSizeInGBs(model.maxDbNodeStorageSizeInGBs);
            this.maxMemoryInGBs(model.maxMemoryInGBs);
            this.memorySizeInGBs(model.memorySizeInGBs);
            this.monthlyDbServerVersion(model.monthlyDbServerVersion);
            this.monthlyStorageServerVersion(model.monthlyStorageServerVersion);
            this.nextMaintenanceRunId(model.nextMaintenanceRunId);
            this.ociResourceAnchorName(model.ociResourceAnchorName);
            this.ociUrl(model.ociUrl);
            this.ocid(model.ocid);
            this.shape(model.shape);
            this.storageCount(model.storageCount);
            this.storageServerVersion(model.storageServerVersion);
            this.createdAt(model.createdAt);
            this.totalStorageSizeInGBs(model.totalStorageSizeInGBs);
            this.percentProgress(model.percentProgress);
            this.databaseServerType(model.databaseServerType);
            this.storageServerType(model.storageServerType);
            this.computeModel(model.computeModel);
        }

        public final String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCloudExadataInfrastructureArn() {
            return this.cloudExadataInfrastructureArn;
        }

        public final void setCloudExadataInfrastructureArn(String cloudExadataInfrastructureArn) {
            this.cloudExadataInfrastructureArn = cloudExadataInfrastructureArn;
        }

        @Override
        public final Builder cloudExadataInfrastructureArn(String cloudExadataInfrastructureArn) {
            this.cloudExadataInfrastructureArn = cloudExadataInfrastructureArn;
            return this;
        }

        public final Integer getActivatedStorageCount() {
            return this.activatedStorageCount;
        }

        public final void setActivatedStorageCount(Integer activatedStorageCount) {
            this.activatedStorageCount = activatedStorageCount;
        }

        @Override
        public final Builder activatedStorageCount(Integer activatedStorageCount) {
            this.activatedStorageCount = activatedStorageCount;
            return this;
        }

        public final Integer getAdditionalStorageCount() {
            return this.additionalStorageCount;
        }

        public final void setAdditionalStorageCount(Integer additionalStorageCount) {
            this.additionalStorageCount = additionalStorageCount;
        }

        @Override
        public final Builder additionalStorageCount(Integer additionalStorageCount) {
            this.additionalStorageCount = additionalStorageCount;
            return this;
        }

        public final Integer getAvailableStorageSizeInGBs() {
            return this.availableStorageSizeInGBs;
        }

        public final void setAvailableStorageSizeInGBs(Integer availableStorageSizeInGBs) {
            this.availableStorageSizeInGBs = availableStorageSizeInGBs;
        }

        @Override
        public final Builder availableStorageSizeInGBs(Integer availableStorageSizeInGBs) {
            this.availableStorageSizeInGBs = availableStorageSizeInGBs;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Integer getComputeCount() {
            return this.computeCount;
        }

        public final void setComputeCount(Integer computeCount) {
            this.computeCount = computeCount;
        }

        @Override
        public final Builder computeCount(Integer computeCount) {
            this.computeCount = computeCount;
            return this;
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final List<CustomerContact.Builder> getCustomerContactsToSendToOCI() {
            List<CustomerContact.Builder> result = CustomerContactsCopier.copyToBuilder(this.customerContactsToSendToOCI);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomerContactsToSendToOCI(Collection<CustomerContact.BuilderImpl> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copyFromBuilder(customerContactsToSendToOCI);
        }

        @Override
        public final Builder customerContactsToSendToOCI(Collection<CustomerContact> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copy(customerContactsToSendToOCI);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(CustomerContact ... customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI(Arrays.asList(customerContactsToSendToOCI));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder> ... customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI(Stream.of(customerContactsToSendToOCI).map(c -> (CustomerContact)((CustomerContact.Builder)CustomerContact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return this.dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final String getDbServerVersion() {
            return this.dbServerVersion;
        }

        public final void setDbServerVersion(String dbServerVersion) {
            this.dbServerVersion = dbServerVersion;
        }

        @Override
        public final Builder dbServerVersion(String dbServerVersion) {
            this.dbServerVersion = dbServerVersion;
            return this;
        }

        public final String getLastMaintenanceRunId() {
            return this.lastMaintenanceRunId;
        }

        public final void setLastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
        }

        @Override
        public final Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return this.maintenanceWindow != null ? this.maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getMaxCpuCount() {
            return this.maxCpuCount;
        }

        public final void setMaxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
        }

        @Override
        public final Builder maxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
            return this;
        }

        public final Double getMaxDataStorageInTBs() {
            return this.maxDataStorageInTBs;
        }

        public final void setMaxDataStorageInTBs(Double maxDataStorageInTBs) {
            this.maxDataStorageInTBs = maxDataStorageInTBs;
        }

        @Override
        public final Builder maxDataStorageInTBs(Double maxDataStorageInTBs) {
            this.maxDataStorageInTBs = maxDataStorageInTBs;
            return this;
        }

        public final Integer getMaxDbNodeStorageSizeInGBs() {
            return this.maxDbNodeStorageSizeInGBs;
        }

        public final void setMaxDbNodeStorageSizeInGBs(Integer maxDbNodeStorageSizeInGBs) {
            this.maxDbNodeStorageSizeInGBs = maxDbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder maxDbNodeStorageSizeInGBs(Integer maxDbNodeStorageSizeInGBs) {
            this.maxDbNodeStorageSizeInGBs = maxDbNodeStorageSizeInGBs;
            return this;
        }

        public final Integer getMaxMemoryInGBs() {
            return this.maxMemoryInGBs;
        }

        public final void setMaxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
        }

        @Override
        public final Builder maxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final String getMonthlyDbServerVersion() {
            return this.monthlyDbServerVersion;
        }

        public final void setMonthlyDbServerVersion(String monthlyDbServerVersion) {
            this.monthlyDbServerVersion = monthlyDbServerVersion;
        }

        @Override
        public final Builder monthlyDbServerVersion(String monthlyDbServerVersion) {
            this.monthlyDbServerVersion = monthlyDbServerVersion;
            return this;
        }

        public final String getMonthlyStorageServerVersion() {
            return this.monthlyStorageServerVersion;
        }

        public final void setMonthlyStorageServerVersion(String monthlyStorageServerVersion) {
            this.monthlyStorageServerVersion = monthlyStorageServerVersion;
        }

        @Override
        public final Builder monthlyStorageServerVersion(String monthlyStorageServerVersion) {
            this.monthlyStorageServerVersion = monthlyStorageServerVersion;
            return this;
        }

        public final String getNextMaintenanceRunId() {
            return this.nextMaintenanceRunId;
        }

        public final void setNextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
        }

        @Override
        public final Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return this.ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getOciUrl() {
            return this.ociUrl;
        }

        public final void setOciUrl(String ociUrl) {
            this.ociUrl = ociUrl;
        }

        @Override
        public final Builder ociUrl(String ociUrl) {
            this.ociUrl = ociUrl;
            return this;
        }

        public final String getOcid() {
            return this.ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Integer getStorageCount() {
            return this.storageCount;
        }

        public final void setStorageCount(Integer storageCount) {
            this.storageCount = storageCount;
        }

        @Override
        public final Builder storageCount(Integer storageCount) {
            this.storageCount = storageCount;
            return this;
        }

        public final String getStorageServerVersion() {
            return this.storageServerVersion;
        }

        public final void setStorageServerVersion(String storageServerVersion) {
            this.storageServerVersion = storageServerVersion;
        }

        @Override
        public final Builder storageServerVersion(String storageServerVersion) {
            this.storageServerVersion = storageServerVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Integer getTotalStorageSizeInGBs() {
            return this.totalStorageSizeInGBs;
        }

        public final void setTotalStorageSizeInGBs(Integer totalStorageSizeInGBs) {
            this.totalStorageSizeInGBs = totalStorageSizeInGBs;
        }

        @Override
        public final Builder totalStorageSizeInGBs(Integer totalStorageSizeInGBs) {
            this.totalStorageSizeInGBs = totalStorageSizeInGBs;
            return this;
        }

        public final Float getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getDatabaseServerType() {
            return this.databaseServerType;
        }

        public final void setDatabaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
        }

        @Override
        public final Builder databaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
            return this;
        }

        public final String getStorageServerType() {
            return this.storageServerType;
        }

        public final void setStorageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
        }

        @Override
        public final Builder storageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
            return this;
        }

        public final String getComputeModel() {
            return this.computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public CloudExadataInfrastructureSummary build() {
            return new CloudExadataInfrastructureSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudExadataInfrastructureSummary> {
        public Builder cloudExadataInfrastructureId(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder cloudExadataInfrastructureArn(String var1);

        public Builder activatedStorageCount(Integer var1);

        public Builder additionalStorageCount(Integer var1);

        public Builder availableStorageSizeInGBs(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder computeCount(Integer var1);

        public Builder cpuCount(Integer var1);

        public Builder customerContactsToSendToOCI(Collection<CustomerContact> var1);

        public Builder customerContactsToSendToOCI(CustomerContact ... var1);

        public Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder> ... var1);

        public Builder dataStorageSizeInTBs(Double var1);

        public Builder dbNodeStorageSizeInGBs(Integer var1);

        public Builder dbServerVersion(String var1);

        public Builder lastMaintenanceRunId(String var1);

        public Builder maintenanceWindow(MaintenanceWindow var1);

        default public Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return this.maintenanceWindow((MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation(maintenanceWindow)).build());
        }

        public Builder maxCpuCount(Integer var1);

        public Builder maxDataStorageInTBs(Double var1);

        public Builder maxDbNodeStorageSizeInGBs(Integer var1);

        public Builder maxMemoryInGBs(Integer var1);

        public Builder memorySizeInGBs(Integer var1);

        public Builder monthlyDbServerVersion(String var1);

        public Builder monthlyStorageServerVersion(String var1);

        public Builder nextMaintenanceRunId(String var1);

        public Builder ociResourceAnchorName(String var1);

        public Builder ociUrl(String var1);

        public Builder ocid(String var1);

        public Builder shape(String var1);

        public Builder storageCount(Integer var1);

        public Builder storageServerVersion(String var1);

        public Builder createdAt(Instant var1);

        public Builder totalStorageSizeInGBs(Integer var1);

        public Builder percentProgress(Float var1);

        public Builder databaseServerType(String var1);

        public Builder storageServerType(String var1);

        public Builder computeModel(String var1);

        public Builder computeModel(ComputeModel var1);
    }
}

