/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.Access;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOdbNetworkRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, UpdateOdbNetworkRequest> {
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::odbNetworkId)).setter(UpdateOdbNetworkRequest.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::displayName)).setter(UpdateOdbNetworkRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<String>> PEERED_CIDRS_TO_BE_ADDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("peeredCidrsToBeAdded").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::peeredCidrsToBeAdded)).setter(UpdateOdbNetworkRequest.setter(Builder::peeredCidrsToBeAdded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrsToBeAdded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PEERED_CIDRS_TO_BE_REMOVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("peeredCidrsToBeRemoved").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::peeredCidrsToBeRemoved)).setter(UpdateOdbNetworkRequest.setter(Builder::peeredCidrsToBeRemoved)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrsToBeRemoved").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> S3_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Access").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::s3AccessAsString)).setter(UpdateOdbNetworkRequest.setter(Builder::s3Access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()}).build();
    private static final SdkField<String> ZERO_ETL_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zeroEtlAccess").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::zeroEtlAccessAsString)).setter(UpdateOdbNetworkRequest.setter(Builder::zeroEtlAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroEtlAccess").build()}).build();
    private static final SdkField<String> STS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stsAccess").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::stsAccessAsString)).setter(UpdateOdbNetworkRequest.setter(Builder::stsAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsAccess").build()}).build();
    private static final SdkField<String> KMS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsAccess").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::kmsAccessAsString)).setter(UpdateOdbNetworkRequest.setter(Builder::kmsAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAccess").build()}).build();
    private static final SdkField<String> S3_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3PolicyDocument").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::s3PolicyDocument)).setter(UpdateOdbNetworkRequest.setter(Builder::s3PolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3PolicyDocument").build()}).build();
    private static final SdkField<String> STS_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stsPolicyDocument").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::stsPolicyDocument)).setter(UpdateOdbNetworkRequest.setter(Builder::stsPolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsPolicyDocument").build()}).build();
    private static final SdkField<String> KMS_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsPolicyDocument").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::kmsPolicyDocument)).setter(UpdateOdbNetworkRequest.setter(Builder::kmsPolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsPolicyDocument").build()}).build();
    private static final SdkField<List<String>> CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crossRegionS3RestoreSourcesToEnable").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::crossRegionS3RestoreSourcesToEnable)).setter(UpdateOdbNetworkRequest.setter(Builder::crossRegionS3RestoreSourcesToEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossRegionS3RestoreSourcesToEnable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CROSS_REGION_S3_RESTORE_SOURCES_TO_DISABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crossRegionS3RestoreSourcesToDisable").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::crossRegionS3RestoreSourcesToDisable)).setter(UpdateOdbNetworkRequest.setter(Builder::crossRegionS3RestoreSourcesToDisable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossRegionS3RestoreSourcesToDisable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_ID_FIELD, DISPLAY_NAME_FIELD, PEERED_CIDRS_TO_BE_ADDED_FIELD, PEERED_CIDRS_TO_BE_REMOVED_FIELD, S3_ACCESS_FIELD, ZERO_ETL_ACCESS_FIELD, STS_ACCESS_FIELD, KMS_ACCESS_FIELD, S3_POLICY_DOCUMENT_FIELD, STS_POLICY_DOCUMENT_FIELD, KMS_POLICY_DOCUMENT_FIELD, CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD, CROSS_REGION_S3_RESTORE_SOURCES_TO_DISABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOdbNetworkRequest.memberNameToFieldInitializer();
    private final String odbNetworkId;
    private final String displayName;
    private final List<String> peeredCidrsToBeAdded;
    private final List<String> peeredCidrsToBeRemoved;
    private final String s3Access;
    private final String zeroEtlAccess;
    private final String stsAccess;
    private final String kmsAccess;
    private final String s3PolicyDocument;
    private final String stsPolicyDocument;
    private final String kmsPolicyDocument;
    private final List<String> crossRegionS3RestoreSourcesToEnable;
    private final List<String> crossRegionS3RestoreSourcesToDisable;

    private UpdateOdbNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.odbNetworkId = builder.odbNetworkId;
        this.displayName = builder.displayName;
        this.peeredCidrsToBeAdded = builder.peeredCidrsToBeAdded;
        this.peeredCidrsToBeRemoved = builder.peeredCidrsToBeRemoved;
        this.s3Access = builder.s3Access;
        this.zeroEtlAccess = builder.zeroEtlAccess;
        this.stsAccess = builder.stsAccess;
        this.kmsAccess = builder.kmsAccess;
        this.s3PolicyDocument = builder.s3PolicyDocument;
        this.stsPolicyDocument = builder.stsPolicyDocument;
        this.kmsPolicyDocument = builder.kmsPolicyDocument;
        this.crossRegionS3RestoreSourcesToEnable = builder.crossRegionS3RestoreSourcesToEnable;
        this.crossRegionS3RestoreSourcesToDisable = builder.crossRegionS3RestoreSourcesToDisable;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasPeeredCidrsToBeAdded() {
        return this.peeredCidrsToBeAdded != null && !(this.peeredCidrsToBeAdded instanceof SdkAutoConstructList);
    }

    public final List<String> peeredCidrsToBeAdded() {
        return this.peeredCidrsToBeAdded;
    }

    public final boolean hasPeeredCidrsToBeRemoved() {
        return this.peeredCidrsToBeRemoved != null && !(this.peeredCidrsToBeRemoved instanceof SdkAutoConstructList);
    }

    public final List<String> peeredCidrsToBeRemoved() {
        return this.peeredCidrsToBeRemoved;
    }

    public final Access s3Access() {
        return Access.fromValue(this.s3Access);
    }

    public final String s3AccessAsString() {
        return this.s3Access;
    }

    public final Access zeroEtlAccess() {
        return Access.fromValue(this.zeroEtlAccess);
    }

    public final String zeroEtlAccessAsString() {
        return this.zeroEtlAccess;
    }

    public final Access stsAccess() {
        return Access.fromValue(this.stsAccess);
    }

    public final String stsAccessAsString() {
        return this.stsAccess;
    }

    public final Access kmsAccess() {
        return Access.fromValue(this.kmsAccess);
    }

    public final String kmsAccessAsString() {
        return this.kmsAccess;
    }

    public final String s3PolicyDocument() {
        return this.s3PolicyDocument;
    }

    public final String stsPolicyDocument() {
        return this.stsPolicyDocument;
    }

    public final String kmsPolicyDocument() {
        return this.kmsPolicyDocument;
    }

    public final boolean hasCrossRegionS3RestoreSourcesToEnable() {
        return this.crossRegionS3RestoreSourcesToEnable != null && !(this.crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList);
    }

    public final List<String> crossRegionS3RestoreSourcesToEnable() {
        return this.crossRegionS3RestoreSourcesToEnable;
    }

    public final boolean hasCrossRegionS3RestoreSourcesToDisable() {
        return this.crossRegionS3RestoreSourcesToDisable != null && !(this.crossRegionS3RestoreSourcesToDisable instanceof SdkAutoConstructList);
    }

    public final List<String> crossRegionS3RestoreSourcesToDisable() {
        return this.crossRegionS3RestoreSourcesToDisable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeeredCidrsToBeAdded() ? this.peeredCidrsToBeAdded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeeredCidrsToBeRemoved() ? this.peeredCidrsToBeRemoved() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroEtlAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.stsPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionS3RestoreSourcesToEnable() ? this.crossRegionS3RestoreSourcesToEnable() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionS3RestoreSourcesToDisable() ? this.crossRegionS3RestoreSourcesToDisable() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOdbNetworkRequest)) {
            return false;
        }
        UpdateOdbNetworkRequest other = (UpdateOdbNetworkRequest)((Object)obj);
        return Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.displayName(), other.displayName()) && this.hasPeeredCidrsToBeAdded() == other.hasPeeredCidrsToBeAdded() && Objects.equals(this.peeredCidrsToBeAdded(), other.peeredCidrsToBeAdded()) && this.hasPeeredCidrsToBeRemoved() == other.hasPeeredCidrsToBeRemoved() && Objects.equals(this.peeredCidrsToBeRemoved(), other.peeredCidrsToBeRemoved()) && Objects.equals(this.s3AccessAsString(), other.s3AccessAsString()) && Objects.equals(this.zeroEtlAccessAsString(), other.zeroEtlAccessAsString()) && Objects.equals(this.stsAccessAsString(), other.stsAccessAsString()) && Objects.equals(this.kmsAccessAsString(), other.kmsAccessAsString()) && Objects.equals(this.s3PolicyDocument(), other.s3PolicyDocument()) && Objects.equals(this.stsPolicyDocument(), other.stsPolicyDocument()) && Objects.equals(this.kmsPolicyDocument(), other.kmsPolicyDocument()) && this.hasCrossRegionS3RestoreSourcesToEnable() == other.hasCrossRegionS3RestoreSourcesToEnable() && Objects.equals(this.crossRegionS3RestoreSourcesToEnable(), other.crossRegionS3RestoreSourcesToEnable()) && this.hasCrossRegionS3RestoreSourcesToDisable() == other.hasCrossRegionS3RestoreSourcesToDisable() && Objects.equals(this.crossRegionS3RestoreSourcesToDisable(), other.crossRegionS3RestoreSourcesToDisable());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOdbNetworkRequest").add("OdbNetworkId", (Object)this.odbNetworkId()).add("DisplayName", (Object)this.displayName()).add("PeeredCidrsToBeAdded", this.hasPeeredCidrsToBeAdded() ? this.peeredCidrsToBeAdded() : null).add("PeeredCidrsToBeRemoved", this.hasPeeredCidrsToBeRemoved() ? this.peeredCidrsToBeRemoved() : null).add("S3Access", (Object)this.s3AccessAsString()).add("ZeroEtlAccess", (Object)this.zeroEtlAccessAsString()).add("StsAccess", (Object)this.stsAccessAsString()).add("KmsAccess", (Object)this.kmsAccessAsString()).add("S3PolicyDocument", (Object)this.s3PolicyDocument()).add("StsPolicyDocument", (Object)this.stsPolicyDocument()).add("KmsPolicyDocument", (Object)this.kmsPolicyDocument()).add("CrossRegionS3RestoreSourcesToEnable", this.hasCrossRegionS3RestoreSourcesToEnable() ? this.crossRegionS3RestoreSourcesToEnable() : null).add("CrossRegionS3RestoreSourcesToDisable", this.hasCrossRegionS3RestoreSourcesToDisable() ? this.crossRegionS3RestoreSourcesToDisable() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "peeredCidrsToBeAdded": {
                return Optional.ofNullable(clazz.cast(this.peeredCidrsToBeAdded()));
            }
            case "peeredCidrsToBeRemoved": {
                return Optional.ofNullable(clazz.cast(this.peeredCidrsToBeRemoved()));
            }
            case "s3Access": {
                return Optional.ofNullable(clazz.cast(this.s3AccessAsString()));
            }
            case "zeroEtlAccess": {
                return Optional.ofNullable(clazz.cast(this.zeroEtlAccessAsString()));
            }
            case "stsAccess": {
                return Optional.ofNullable(clazz.cast(this.stsAccessAsString()));
            }
            case "kmsAccess": {
                return Optional.ofNullable(clazz.cast(this.kmsAccessAsString()));
            }
            case "s3PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.s3PolicyDocument()));
            }
            case "stsPolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.stsPolicyDocument()));
            }
            case "kmsPolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.kmsPolicyDocument()));
            }
            case "crossRegionS3RestoreSourcesToEnable": {
                return Optional.ofNullable(clazz.cast(this.crossRegionS3RestoreSourcesToEnable()));
            }
            case "crossRegionS3RestoreSourcesToDisable": {
                return Optional.ofNullable(clazz.cast(this.crossRegionS3RestoreSourcesToDisable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("peeredCidrsToBeAdded", PEERED_CIDRS_TO_BE_ADDED_FIELD);
        map.put("peeredCidrsToBeRemoved", PEERED_CIDRS_TO_BE_REMOVED_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        map.put("zeroEtlAccess", ZERO_ETL_ACCESS_FIELD);
        map.put("stsAccess", STS_ACCESS_FIELD);
        map.put("kmsAccess", KMS_ACCESS_FIELD);
        map.put("s3PolicyDocument", S3_POLICY_DOCUMENT_FIELD);
        map.put("stsPolicyDocument", STS_POLICY_DOCUMENT_FIELD);
        map.put("kmsPolicyDocument", KMS_POLICY_DOCUMENT_FIELD);
        map.put("crossRegionS3RestoreSourcesToEnable", CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD);
        map.put("crossRegionS3RestoreSourcesToDisable", CROSS_REGION_S3_RESTORE_SOURCES_TO_DISABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOdbNetworkRequest, T> g) {
        return obj -> g.apply((UpdateOdbNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String odbNetworkId;
        private String displayName;
        private List<String> peeredCidrsToBeAdded = DefaultSdkAutoConstructList.getInstance();
        private List<String> peeredCidrsToBeRemoved = DefaultSdkAutoConstructList.getInstance();
        private String s3Access;
        private String zeroEtlAccess;
        private String stsAccess;
        private String kmsAccess;
        private String s3PolicyDocument;
        private String stsPolicyDocument;
        private String kmsPolicyDocument;
        private List<String> crossRegionS3RestoreSourcesToEnable = DefaultSdkAutoConstructList.getInstance();
        private List<String> crossRegionS3RestoreSourcesToDisable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOdbNetworkRequest model) {
            super(model);
            this.odbNetworkId(model.odbNetworkId);
            this.displayName(model.displayName);
            this.peeredCidrsToBeAdded(model.peeredCidrsToBeAdded);
            this.peeredCidrsToBeRemoved(model.peeredCidrsToBeRemoved);
            this.s3Access(model.s3Access);
            this.zeroEtlAccess(model.zeroEtlAccess);
            this.stsAccess(model.stsAccess);
            this.kmsAccess(model.kmsAccess);
            this.s3PolicyDocument(model.s3PolicyDocument);
            this.stsPolicyDocument(model.stsPolicyDocument);
            this.kmsPolicyDocument(model.kmsPolicyDocument);
            this.crossRegionS3RestoreSourcesToEnable(model.crossRegionS3RestoreSourcesToEnable);
            this.crossRegionS3RestoreSourcesToDisable(model.crossRegionS3RestoreSourcesToDisable);
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getPeeredCidrsToBeAdded() {
            if (this.peeredCidrsToBeAdded instanceof SdkAutoConstructList) {
                return null;
            }
            return this.peeredCidrsToBeAdded;
        }

        public final void setPeeredCidrsToBeAdded(Collection<String> peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded = StringListCopier.copy(peeredCidrsToBeAdded);
        }

        @Override
        public final Builder peeredCidrsToBeAdded(Collection<String> peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded = StringListCopier.copy(peeredCidrsToBeAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrsToBeAdded(String ... peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded(Arrays.asList(peeredCidrsToBeAdded));
            return this;
        }

        public final Collection<String> getPeeredCidrsToBeRemoved() {
            if (this.peeredCidrsToBeRemoved instanceof SdkAutoConstructList) {
                return null;
            }
            return this.peeredCidrsToBeRemoved;
        }

        public final void setPeeredCidrsToBeRemoved(Collection<String> peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved = StringListCopier.copy(peeredCidrsToBeRemoved);
        }

        @Override
        public final Builder peeredCidrsToBeRemoved(Collection<String> peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved = StringListCopier.copy(peeredCidrsToBeRemoved);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrsToBeRemoved(String ... peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved(Arrays.asList(peeredCidrsToBeRemoved));
            return this;
        }

        public final String getS3Access() {
            return this.s3Access;
        }

        public final void setS3Access(String s3Access) {
            this.s3Access = s3Access;
        }

        @Override
        public final Builder s3Access(String s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        @Override
        public final Builder s3Access(Access s3Access) {
            this.s3Access(s3Access == null ? null : s3Access.toString());
            return this;
        }

        public final String getZeroEtlAccess() {
            return this.zeroEtlAccess;
        }

        public final void setZeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
        }

        @Override
        public final Builder zeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
            return this;
        }

        @Override
        public final Builder zeroEtlAccess(Access zeroEtlAccess) {
            this.zeroEtlAccess(zeroEtlAccess == null ? null : zeroEtlAccess.toString());
            return this;
        }

        public final String getStsAccess() {
            return this.stsAccess;
        }

        public final void setStsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
        }

        @Override
        public final Builder stsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
            return this;
        }

        @Override
        public final Builder stsAccess(Access stsAccess) {
            this.stsAccess(stsAccess == null ? null : stsAccess.toString());
            return this;
        }

        public final String getKmsAccess() {
            return this.kmsAccess;
        }

        public final void setKmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
        }

        @Override
        public final Builder kmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
            return this;
        }

        @Override
        public final Builder kmsAccess(Access kmsAccess) {
            this.kmsAccess(kmsAccess == null ? null : kmsAccess.toString());
            return this;
        }

        public final String getS3PolicyDocument() {
            return this.s3PolicyDocument;
        }

        public final void setS3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
        }

        @Override
        public final Builder s3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
            return this;
        }

        public final String getStsPolicyDocument() {
            return this.stsPolicyDocument;
        }

        public final void setStsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
        }

        @Override
        public final Builder stsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
            return this;
        }

        public final String getKmsPolicyDocument() {
            return this.kmsPolicyDocument;
        }

        public final void setKmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
        }

        @Override
        public final Builder kmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
            return this;
        }

        public final Collection<String> getCrossRegionS3RestoreSourcesToEnable() {
            if (this.crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crossRegionS3RestoreSourcesToEnable;
        }

        public final void setCrossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
        }

        @Override
        public final Builder crossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesToEnable(String ... crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable(Arrays.asList(crossRegionS3RestoreSourcesToEnable));
            return this;
        }

        public final Collection<String> getCrossRegionS3RestoreSourcesToDisable() {
            if (this.crossRegionS3RestoreSourcesToDisable instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crossRegionS3RestoreSourcesToDisable;
        }

        public final void setCrossRegionS3RestoreSourcesToDisable(Collection<String> crossRegionS3RestoreSourcesToDisable) {
            this.crossRegionS3RestoreSourcesToDisable = StringListCopier.copy(crossRegionS3RestoreSourcesToDisable);
        }

        @Override
        public final Builder crossRegionS3RestoreSourcesToDisable(Collection<String> crossRegionS3RestoreSourcesToDisable) {
            this.crossRegionS3RestoreSourcesToDisable = StringListCopier.copy(crossRegionS3RestoreSourcesToDisable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesToDisable(String ... crossRegionS3RestoreSourcesToDisable) {
            this.crossRegionS3RestoreSourcesToDisable(Arrays.asList(crossRegionS3RestoreSourcesToDisable));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOdbNetworkRequest build() {
            return new UpdateOdbNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOdbNetworkRequest> {
        public Builder odbNetworkId(String var1);

        public Builder displayName(String var1);

        public Builder peeredCidrsToBeAdded(Collection<String> var1);

        public Builder peeredCidrsToBeAdded(String ... var1);

        public Builder peeredCidrsToBeRemoved(Collection<String> var1);

        public Builder peeredCidrsToBeRemoved(String ... var1);

        public Builder s3Access(String var1);

        public Builder s3Access(Access var1);

        public Builder zeroEtlAccess(String var1);

        public Builder zeroEtlAccess(Access var1);

        public Builder stsAccess(String var1);

        public Builder stsAccess(Access var1);

        public Builder kmsAccess(String var1);

        public Builder kmsAccess(Access var1);

        public Builder s3PolicyDocument(String var1);

        public Builder stsPolicyDocument(String var1);

        public Builder kmsPolicyDocument(String var1);

        public Builder crossRegionS3RestoreSourcesToEnable(Collection<String> var1);

        public Builder crossRegionS3RestoreSourcesToEnable(String ... var1);

        public Builder crossRegionS3RestoreSourcesToDisable(Collection<String> var1);

        public Builder crossRegionS3RestoreSourcesToDisable(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

