/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.PeeredCidrListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOdbPeeringConnectionRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, UpdateOdbPeeringConnectionRequest> {
    private static final SdkField<String> ODB_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbPeeringConnectionId").getter(UpdateOdbPeeringConnectionRequest.getter(UpdateOdbPeeringConnectionRequest::odbPeeringConnectionId)).setter(UpdateOdbPeeringConnectionRequest.setter(Builder::odbPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnectionId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateOdbPeeringConnectionRequest.getter(UpdateOdbPeeringConnectionRequest::displayName)).setter(UpdateOdbPeeringConnectionRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<String>> PEER_NETWORK_CIDRS_TO_BE_ADDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("peerNetworkCidrsToBeAdded").getter(UpdateOdbPeeringConnectionRequest.getter(UpdateOdbPeeringConnectionRequest::peerNetworkCidrsToBeAdded)).setter(UpdateOdbPeeringConnectionRequest.setter(Builder::peerNetworkCidrsToBeAdded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerNetworkCidrsToBeAdded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PEER_NETWORK_CIDRS_TO_BE_REMOVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("peerNetworkCidrsToBeRemoved").getter(UpdateOdbPeeringConnectionRequest.getter(UpdateOdbPeeringConnectionRequest::peerNetworkCidrsToBeRemoved)).setter(UpdateOdbPeeringConnectionRequest.setter(Builder::peerNetworkCidrsToBeRemoved)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerNetworkCidrsToBeRemoved").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_PEERING_CONNECTION_ID_FIELD, DISPLAY_NAME_FIELD, PEER_NETWORK_CIDRS_TO_BE_ADDED_FIELD, PEER_NETWORK_CIDRS_TO_BE_REMOVED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOdbPeeringConnectionRequest.memberNameToFieldInitializer();
    private final String odbPeeringConnectionId;
    private final String displayName;
    private final List<String> peerNetworkCidrsToBeAdded;
    private final List<String> peerNetworkCidrsToBeRemoved;

    private UpdateOdbPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.odbPeeringConnectionId = builder.odbPeeringConnectionId;
        this.displayName = builder.displayName;
        this.peerNetworkCidrsToBeAdded = builder.peerNetworkCidrsToBeAdded;
        this.peerNetworkCidrsToBeRemoved = builder.peerNetworkCidrsToBeRemoved;
    }

    public final String odbPeeringConnectionId() {
        return this.odbPeeringConnectionId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasPeerNetworkCidrsToBeAdded() {
        return this.peerNetworkCidrsToBeAdded != null && !(this.peerNetworkCidrsToBeAdded instanceof SdkAutoConstructList);
    }

    public final List<String> peerNetworkCidrsToBeAdded() {
        return this.peerNetworkCidrsToBeAdded;
    }

    public final boolean hasPeerNetworkCidrsToBeRemoved() {
        return this.peerNetworkCidrsToBeRemoved != null && !(this.peerNetworkCidrsToBeRemoved instanceof SdkAutoConstructList);
    }

    public final List<String> peerNetworkCidrsToBeRemoved() {
        return this.peerNetworkCidrsToBeRemoved;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.odbPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeerNetworkCidrsToBeAdded() ? this.peerNetworkCidrsToBeAdded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeerNetworkCidrsToBeRemoved() ? this.peerNetworkCidrsToBeRemoved() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOdbPeeringConnectionRequest)) {
            return false;
        }
        UpdateOdbPeeringConnectionRequest other = (UpdateOdbPeeringConnectionRequest)((Object)obj);
        return Objects.equals(this.odbPeeringConnectionId(), other.odbPeeringConnectionId()) && Objects.equals(this.displayName(), other.displayName()) && this.hasPeerNetworkCidrsToBeAdded() == other.hasPeerNetworkCidrsToBeAdded() && Objects.equals(this.peerNetworkCidrsToBeAdded(), other.peerNetworkCidrsToBeAdded()) && this.hasPeerNetworkCidrsToBeRemoved() == other.hasPeerNetworkCidrsToBeRemoved() && Objects.equals(this.peerNetworkCidrsToBeRemoved(), other.peerNetworkCidrsToBeRemoved());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOdbPeeringConnectionRequest").add("OdbPeeringConnectionId", (Object)this.odbPeeringConnectionId()).add("DisplayName", (Object)this.displayName()).add("PeerNetworkCidrsToBeAdded", this.hasPeerNetworkCidrsToBeAdded() ? this.peerNetworkCidrsToBeAdded() : null).add("PeerNetworkCidrsToBeRemoved", this.hasPeerNetworkCidrsToBeRemoved() ? this.peerNetworkCidrsToBeRemoved() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "odbPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.odbPeeringConnectionId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "peerNetworkCidrsToBeAdded": {
                return Optional.ofNullable(clazz.cast(this.peerNetworkCidrsToBeAdded()));
            }
            case "peerNetworkCidrsToBeRemoved": {
                return Optional.ofNullable(clazz.cast(this.peerNetworkCidrsToBeRemoved()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("odbPeeringConnectionId", ODB_PEERING_CONNECTION_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("peerNetworkCidrsToBeAdded", PEER_NETWORK_CIDRS_TO_BE_ADDED_FIELD);
        map.put("peerNetworkCidrsToBeRemoved", PEER_NETWORK_CIDRS_TO_BE_REMOVED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOdbPeeringConnectionRequest, T> g) {
        return obj -> g.apply((UpdateOdbPeeringConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String odbPeeringConnectionId;
        private String displayName;
        private List<String> peerNetworkCidrsToBeAdded = DefaultSdkAutoConstructList.getInstance();
        private List<String> peerNetworkCidrsToBeRemoved = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOdbPeeringConnectionRequest model) {
            super(model);
            this.odbPeeringConnectionId(model.odbPeeringConnectionId);
            this.displayName(model.displayName);
            this.peerNetworkCidrsToBeAdded(model.peerNetworkCidrsToBeAdded);
            this.peerNetworkCidrsToBeRemoved(model.peerNetworkCidrsToBeRemoved);
        }

        public final String getOdbPeeringConnectionId() {
            return this.odbPeeringConnectionId;
        }

        public final void setOdbPeeringConnectionId(String odbPeeringConnectionId) {
            this.odbPeeringConnectionId = odbPeeringConnectionId;
        }

        @Override
        public final Builder odbPeeringConnectionId(String odbPeeringConnectionId) {
            this.odbPeeringConnectionId = odbPeeringConnectionId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getPeerNetworkCidrsToBeAdded() {
            if (this.peerNetworkCidrsToBeAdded instanceof SdkAutoConstructList) {
                return null;
            }
            return this.peerNetworkCidrsToBeAdded;
        }

        public final void setPeerNetworkCidrsToBeAdded(Collection<String> peerNetworkCidrsToBeAdded) {
            this.peerNetworkCidrsToBeAdded = PeeredCidrListCopier.copy(peerNetworkCidrsToBeAdded);
        }

        @Override
        public final Builder peerNetworkCidrsToBeAdded(Collection<String> peerNetworkCidrsToBeAdded) {
            this.peerNetworkCidrsToBeAdded = PeeredCidrListCopier.copy(peerNetworkCidrsToBeAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peerNetworkCidrsToBeAdded(String ... peerNetworkCidrsToBeAdded) {
            this.peerNetworkCidrsToBeAdded(Arrays.asList(peerNetworkCidrsToBeAdded));
            return this;
        }

        public final Collection<String> getPeerNetworkCidrsToBeRemoved() {
            if (this.peerNetworkCidrsToBeRemoved instanceof SdkAutoConstructList) {
                return null;
            }
            return this.peerNetworkCidrsToBeRemoved;
        }

        public final void setPeerNetworkCidrsToBeRemoved(Collection<String> peerNetworkCidrsToBeRemoved) {
            this.peerNetworkCidrsToBeRemoved = PeeredCidrListCopier.copy(peerNetworkCidrsToBeRemoved);
        }

        @Override
        public final Builder peerNetworkCidrsToBeRemoved(Collection<String> peerNetworkCidrsToBeRemoved) {
            this.peerNetworkCidrsToBeRemoved = PeeredCidrListCopier.copy(peerNetworkCidrsToBeRemoved);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peerNetworkCidrsToBeRemoved(String ... peerNetworkCidrsToBeRemoved) {
            this.peerNetworkCidrsToBeRemoved(Arrays.asList(peerNetworkCidrsToBeRemoved));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOdbPeeringConnectionRequest build() {
            return new UpdateOdbPeeringConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOdbPeeringConnectionRequest> {
        public Builder odbPeeringConnectionId(String var1);

        public Builder displayName(String var1);

        public Builder peerNetworkCidrsToBeAdded(Collection<String> var1);

        public Builder peerNetworkCidrsToBeAdded(String ... var1);

        public Builder peerNetworkCidrsToBeRemoved(Collection<String> var1);

        public Builder peerNetworkCidrsToBeRemoved(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

