/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.odb.model.Access;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.RequestTagMapCopier;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOdbNetworkRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, CreateOdbNetworkRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::displayName)).setter(CreateOdbNetworkRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::availabilityZone)).setter(CreateOdbNetworkRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::availabilityZoneId)).setter(CreateOdbNetworkRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> CLIENT_SUBNET_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSubnetCidr").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::clientSubnetCidr)).setter(CreateOdbNetworkRequest.setter(Builder::clientSubnetCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnetCidr").build()}).build();
    private static final SdkField<String> BACKUP_SUBNET_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backupSubnetCidr").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::backupSubnetCidr)).setter(CreateOdbNetworkRequest.setter(Builder::backupSubnetCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupSubnetCidr").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::customDomainName)).setter(CreateOdbNetworkRequest.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final SdkField<String> DEFAULT_DNS_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultDnsPrefix").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::defaultDnsPrefix)).setter(CreateOdbNetworkRequest.setter(Builder::defaultDnsPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDnsPrefix").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::clientToken)).setter(CreateOdbNetworkRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> S3_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Access").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::s3AccessAsString)).setter(CreateOdbNetworkRequest.setter(Builder::s3Access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()}).build();
    private static final SdkField<String> ZERO_ETL_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zeroEtlAccess").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::zeroEtlAccessAsString)).setter(CreateOdbNetworkRequest.setter(Builder::zeroEtlAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroEtlAccess").build()}).build();
    private static final SdkField<String> STS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stsAccess").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::stsAccessAsString)).setter(CreateOdbNetworkRequest.setter(Builder::stsAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsAccess").build()}).build();
    private static final SdkField<String> KMS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsAccess").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::kmsAccessAsString)).setter(CreateOdbNetworkRequest.setter(Builder::kmsAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAccess").build()}).build();
    private static final SdkField<String> S3_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3PolicyDocument").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::s3PolicyDocument)).setter(CreateOdbNetworkRequest.setter(Builder::s3PolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3PolicyDocument").build()}).build();
    private static final SdkField<String> STS_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stsPolicyDocument").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::stsPolicyDocument)).setter(CreateOdbNetworkRequest.setter(Builder::stsPolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsPolicyDocument").build()}).build();
    private static final SdkField<String> KMS_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsPolicyDocument").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::kmsPolicyDocument)).setter(CreateOdbNetworkRequest.setter(Builder::kmsPolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsPolicyDocument").build()}).build();
    private static final SdkField<List<String>> CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crossRegionS3RestoreSourcesToEnable").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::crossRegionS3RestoreSourcesToEnable)).setter(CreateOdbNetworkRequest.setter(Builder::crossRegionS3RestoreSourcesToEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossRegionS3RestoreSourcesToEnable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateOdbNetworkRequest.getter(CreateOdbNetworkRequest::tags)).setter(CreateOdbNetworkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CLIENT_SUBNET_CIDR_FIELD, BACKUP_SUBNET_CIDR_FIELD, CUSTOM_DOMAIN_NAME_FIELD, DEFAULT_DNS_PREFIX_FIELD, CLIENT_TOKEN_FIELD, S3_ACCESS_FIELD, ZERO_ETL_ACCESS_FIELD, STS_ACCESS_FIELD, KMS_ACCESS_FIELD, S3_POLICY_DOCUMENT_FIELD, STS_POLICY_DOCUMENT_FIELD, KMS_POLICY_DOCUMENT_FIELD, CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOdbNetworkRequest.memberNameToFieldInitializer();
    private final String displayName;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final String clientSubnetCidr;
    private final String backupSubnetCidr;
    private final String customDomainName;
    private final String defaultDnsPrefix;
    private final String clientToken;
    private final String s3Access;
    private final String zeroEtlAccess;
    private final String stsAccess;
    private final String kmsAccess;
    private final String s3PolicyDocument;
    private final String stsPolicyDocument;
    private final String kmsPolicyDocument;
    private final List<String> crossRegionS3RestoreSourcesToEnable;
    private final Map<String, String> tags;

    private CreateOdbNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.clientSubnetCidr = builder.clientSubnetCidr;
        this.backupSubnetCidr = builder.backupSubnetCidr;
        this.customDomainName = builder.customDomainName;
        this.defaultDnsPrefix = builder.defaultDnsPrefix;
        this.clientToken = builder.clientToken;
        this.s3Access = builder.s3Access;
        this.zeroEtlAccess = builder.zeroEtlAccess;
        this.stsAccess = builder.stsAccess;
        this.kmsAccess = builder.kmsAccess;
        this.s3PolicyDocument = builder.s3PolicyDocument;
        this.stsPolicyDocument = builder.stsPolicyDocument;
        this.kmsPolicyDocument = builder.kmsPolicyDocument;
        this.crossRegionS3RestoreSourcesToEnable = builder.crossRegionS3RestoreSourcesToEnable;
        this.tags = builder.tags;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String clientSubnetCidr() {
        return this.clientSubnetCidr;
    }

    public final String backupSubnetCidr() {
        return this.backupSubnetCidr;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final String defaultDnsPrefix() {
        return this.defaultDnsPrefix;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Access s3Access() {
        return Access.fromValue(this.s3Access);
    }

    public final String s3AccessAsString() {
        return this.s3Access;
    }

    public final Access zeroEtlAccess() {
        return Access.fromValue(this.zeroEtlAccess);
    }

    public final String zeroEtlAccessAsString() {
        return this.zeroEtlAccess;
    }

    public final Access stsAccess() {
        return Access.fromValue(this.stsAccess);
    }

    public final String stsAccessAsString() {
        return this.stsAccess;
    }

    public final Access kmsAccess() {
        return Access.fromValue(this.kmsAccess);
    }

    public final String kmsAccessAsString() {
        return this.kmsAccess;
    }

    public final String s3PolicyDocument() {
        return this.s3PolicyDocument;
    }

    public final String stsPolicyDocument() {
        return this.stsPolicyDocument;
    }

    public final String kmsPolicyDocument() {
        return this.kmsPolicyDocument;
    }

    public final boolean hasCrossRegionS3RestoreSourcesToEnable() {
        return this.crossRegionS3RestoreSourcesToEnable != null && !(this.crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList);
    }

    public final List<String> crossRegionS3RestoreSourcesToEnable() {
        return this.crossRegionS3RestoreSourcesToEnable;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDnsPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroEtlAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.stsPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionS3RestoreSourcesToEnable() ? this.crossRegionS3RestoreSourcesToEnable() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOdbNetworkRequest)) {
            return false;
        }
        CreateOdbNetworkRequest other = (CreateOdbNetworkRequest)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.clientSubnetCidr(), other.clientSubnetCidr()) && Objects.equals(this.backupSubnetCidr(), other.backupSubnetCidr()) && Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.defaultDnsPrefix(), other.defaultDnsPrefix()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.s3AccessAsString(), other.s3AccessAsString()) && Objects.equals(this.zeroEtlAccessAsString(), other.zeroEtlAccessAsString()) && Objects.equals(this.stsAccessAsString(), other.stsAccessAsString()) && Objects.equals(this.kmsAccessAsString(), other.kmsAccessAsString()) && Objects.equals(this.s3PolicyDocument(), other.s3PolicyDocument()) && Objects.equals(this.stsPolicyDocument(), other.stsPolicyDocument()) && Objects.equals(this.kmsPolicyDocument(), other.kmsPolicyDocument()) && this.hasCrossRegionS3RestoreSourcesToEnable() == other.hasCrossRegionS3RestoreSourcesToEnable() && Objects.equals(this.crossRegionS3RestoreSourcesToEnable(), other.crossRegionS3RestoreSourcesToEnable()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOdbNetworkRequest").add("DisplayName", (Object)this.displayName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("ClientSubnetCidr", (Object)this.clientSubnetCidr()).add("BackupSubnetCidr", (Object)this.backupSubnetCidr()).add("CustomDomainName", (Object)this.customDomainName()).add("DefaultDnsPrefix", (Object)this.defaultDnsPrefix()).add("ClientToken", (Object)this.clientToken()).add("S3Access", (Object)this.s3AccessAsString()).add("ZeroEtlAccess", (Object)this.zeroEtlAccessAsString()).add("StsAccess", (Object)this.stsAccessAsString()).add("KmsAccess", (Object)this.kmsAccessAsString()).add("S3PolicyDocument", (Object)this.s3PolicyDocument()).add("StsPolicyDocument", (Object)this.stsPolicyDocument()).add("KmsPolicyDocument", (Object)this.kmsPolicyDocument()).add("CrossRegionS3RestoreSourcesToEnable", this.hasCrossRegionS3RestoreSourcesToEnable() ? this.crossRegionS3RestoreSourcesToEnable() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "clientSubnetCidr": {
                return Optional.ofNullable(clazz.cast(this.clientSubnetCidr()));
            }
            case "backupSubnetCidr": {
                return Optional.ofNullable(clazz.cast(this.backupSubnetCidr()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "defaultDnsPrefix": {
                return Optional.ofNullable(clazz.cast(this.defaultDnsPrefix()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "s3Access": {
                return Optional.ofNullable(clazz.cast(this.s3AccessAsString()));
            }
            case "zeroEtlAccess": {
                return Optional.ofNullable(clazz.cast(this.zeroEtlAccessAsString()));
            }
            case "stsAccess": {
                return Optional.ofNullable(clazz.cast(this.stsAccessAsString()));
            }
            case "kmsAccess": {
                return Optional.ofNullable(clazz.cast(this.kmsAccessAsString()));
            }
            case "s3PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.s3PolicyDocument()));
            }
            case "stsPolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.stsPolicyDocument()));
            }
            case "kmsPolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.kmsPolicyDocument()));
            }
            case "crossRegionS3RestoreSourcesToEnable": {
                return Optional.ofNullable(clazz.cast(this.crossRegionS3RestoreSourcesToEnable()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("clientSubnetCidr", CLIENT_SUBNET_CIDR_FIELD);
        map.put("backupSubnetCidr", BACKUP_SUBNET_CIDR_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("defaultDnsPrefix", DEFAULT_DNS_PREFIX_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        map.put("zeroEtlAccess", ZERO_ETL_ACCESS_FIELD);
        map.put("stsAccess", STS_ACCESS_FIELD);
        map.put("kmsAccess", KMS_ACCESS_FIELD);
        map.put("s3PolicyDocument", S3_POLICY_DOCUMENT_FIELD);
        map.put("stsPolicyDocument", STS_POLICY_DOCUMENT_FIELD);
        map.put("kmsPolicyDocument", KMS_POLICY_DOCUMENT_FIELD);
        map.put("crossRegionS3RestoreSourcesToEnable", CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOdbNetworkRequest, T> g) {
        return obj -> g.apply((CreateOdbNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String displayName;
        private String availabilityZone;
        private String availabilityZoneId;
        private String clientSubnetCidr;
        private String backupSubnetCidr;
        private String customDomainName;
        private String defaultDnsPrefix;
        private String clientToken;
        private String s3Access;
        private String zeroEtlAccess;
        private String stsAccess;
        private String kmsAccess;
        private String s3PolicyDocument;
        private String stsPolicyDocument;
        private String kmsPolicyDocument;
        private List<String> crossRegionS3RestoreSourcesToEnable = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOdbNetworkRequest model) {
            super(model);
            this.displayName(model.displayName);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.clientSubnetCidr(model.clientSubnetCidr);
            this.backupSubnetCidr(model.backupSubnetCidr);
            this.customDomainName(model.customDomainName);
            this.defaultDnsPrefix(model.defaultDnsPrefix);
            this.clientToken(model.clientToken);
            this.s3Access(model.s3Access);
            this.zeroEtlAccess(model.zeroEtlAccess);
            this.stsAccess(model.stsAccess);
            this.kmsAccess(model.kmsAccess);
            this.s3PolicyDocument(model.s3PolicyDocument);
            this.stsPolicyDocument(model.stsPolicyDocument);
            this.kmsPolicyDocument(model.kmsPolicyDocument);
            this.crossRegionS3RestoreSourcesToEnable(model.crossRegionS3RestoreSourcesToEnable);
            this.tags(model.tags);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getClientSubnetCidr() {
            return this.clientSubnetCidr;
        }

        public final void setClientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
        }

        @Override
        public final Builder clientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
            return this;
        }

        public final String getBackupSubnetCidr() {
            return this.backupSubnetCidr;
        }

        public final void setBackupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
        }

        @Override
        public final Builder backupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getDefaultDnsPrefix() {
            return this.defaultDnsPrefix;
        }

        public final void setDefaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
        }

        @Override
        public final Builder defaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getS3Access() {
            return this.s3Access;
        }

        public final void setS3Access(String s3Access) {
            this.s3Access = s3Access;
        }

        @Override
        public final Builder s3Access(String s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        @Override
        public final Builder s3Access(Access s3Access) {
            this.s3Access(s3Access == null ? null : s3Access.toString());
            return this;
        }

        public final String getZeroEtlAccess() {
            return this.zeroEtlAccess;
        }

        public final void setZeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
        }

        @Override
        public final Builder zeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
            return this;
        }

        @Override
        public final Builder zeroEtlAccess(Access zeroEtlAccess) {
            this.zeroEtlAccess(zeroEtlAccess == null ? null : zeroEtlAccess.toString());
            return this;
        }

        public final String getStsAccess() {
            return this.stsAccess;
        }

        public final void setStsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
        }

        @Override
        public final Builder stsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
            return this;
        }

        @Override
        public final Builder stsAccess(Access stsAccess) {
            this.stsAccess(stsAccess == null ? null : stsAccess.toString());
            return this;
        }

        public final String getKmsAccess() {
            return this.kmsAccess;
        }

        public final void setKmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
        }

        @Override
        public final Builder kmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
            return this;
        }

        @Override
        public final Builder kmsAccess(Access kmsAccess) {
            this.kmsAccess(kmsAccess == null ? null : kmsAccess.toString());
            return this;
        }

        public final String getS3PolicyDocument() {
            return this.s3PolicyDocument;
        }

        public final void setS3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
        }

        @Override
        public final Builder s3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
            return this;
        }

        public final String getStsPolicyDocument() {
            return this.stsPolicyDocument;
        }

        public final void setStsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
        }

        @Override
        public final Builder stsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
            return this;
        }

        public final String getKmsPolicyDocument() {
            return this.kmsPolicyDocument;
        }

        public final void setKmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
        }

        @Override
        public final Builder kmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
            return this;
        }

        public final Collection<String> getCrossRegionS3RestoreSourcesToEnable() {
            if (this.crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crossRegionS3RestoreSourcesToEnable;
        }

        public final void setCrossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
        }

        @Override
        public final Builder crossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesToEnable(String ... crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable(Arrays.asList(crossRegionS3RestoreSourcesToEnable));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOdbNetworkRequest build() {
            return new CreateOdbNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOdbNetworkRequest> {
        public Builder displayName(String var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder clientSubnetCidr(String var1);

        public Builder backupSubnetCidr(String var1);

        public Builder customDomainName(String var1);

        public Builder defaultDnsPrefix(String var1);

        public Builder clientToken(String var1);

        public Builder s3Access(String var1);

        public Builder s3Access(Access var1);

        public Builder zeroEtlAccess(String var1);

        public Builder zeroEtlAccess(Access var1);

        public Builder stsAccess(String var1);

        public Builder stsAccess(Access var1);

        public Builder kmsAccess(String var1);

        public Builder kmsAccess(Access var1);

        public Builder s3PolicyDocument(String var1);

        public Builder stsPolicyDocument(String var1);

        public Builder kmsPolicyDocument(String var1);

        public Builder crossRegionS3RestoreSourcesToEnable(Collection<String> var1);

        public Builder crossRegionS3RestoreSourcesToEnable(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

