/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShapeType {
    AMD("AMD"),
    INTEL("INTEL"),
    INTEL_FLEX_X9("INTEL_FLEX_X9"),
    AMPERE_FLEX_A1("AMPERE_FLEX_A1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShapeType> VALUE_MAP;
    private final String value;

    private ShapeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShapeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShapeType> knownValues() {
        EnumSet<ShapeType> knownValues = EnumSet.allOf(ShapeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShapeType.class, ShapeType::toString);
    }
}

